/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ToasterTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int TOAST_TICKS = 1200;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ToasterTileEntity.this.func_70296_d();
            VanillaPacketHandler.sendTileEntityUpdate(ToasterTileEntity.this);
        }
    };
    private boolean active;
    private int toastTicks;

    public ToasterTileEntity() {
        super(ModTileEntities.toaster);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.toasterStart, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 1) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.toasterStop, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 2) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3, 512);
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.active = tagCompound.func_74767_n("Active");
        this.toastTicks = tagCompound.func_74762_e("ToastTicks");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        tagCompound.func_74757_a("Active", this.active);
        tagCompound.func_74768_a("ToastTicks", this.toastTicks);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void func_73660_a() {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0 && !this.field_145850_b.field_72995_K) {
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    ItemStack inputStack = this.itemHandler.getStackInSlot(i);
                    if (inputStack.func_190926_b()) continue;
                    ToasterHandler toastHandler = CookingRegistry.getToasterHandler(inputStack);
                    ItemStack outputStack = toastHandler.getToasterOutput(inputStack);
                    outputStack = outputStack.func_190926_b() ? inputStack : outputStack.func_77946_l();
                    ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.75f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), outputStack);
                    itemEntity.func_213293_j(0.0, (double)0.1f, 0.0);
                    this.field_145850_b.func_217376_c((Entity)itemEntity);
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                this.setActive(false);
            }
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.toastTicks = 1200;
            this.field_145850_b.func_175641_c(this.field_174879_c, ModBlocks.toaster, 0, 0);
        } else {
            this.toastTicks = 0;
            this.field_145850_b.func_175641_c(this.field_174879_c, ModBlocks.toaster, 1, 0);
        }
        this.field_145850_b.func_175641_c(this.field_174879_c, ModBlocks.toaster, 2, 0);
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ToasterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        this.func_70296_d();
    }

    public boolean isActive() {
        return this.active;
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public float getToastProgress() {
        return 1.0f - (float)this.toastTicks / 1200.0f;
    }
}

