/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.combiner;

import al132.alchemistry.RecipeTypes;
import al132.alchemistry.Ref;
import al132.alchemistry.misc.ProcessingRecipe;
import al132.alchemistry.utils.StackUtils;
import al132.alib.tiles.CustomStackHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class CombinerRecipe
extends ProcessingRecipe {
    public final ItemStack output;
    public final List<ItemStack> inputs = new ArrayList<ItemStack>();
    public final Set<Integer> nonEmptyIndices = new HashSet<Integer>();

    public CombinerRecipe(ResourceLocation id, String group, List<ItemStack> input, ItemStack output) {
        super(RecipeTypes.COMBINER, id, group, Ingredient.field_193370_a, ItemStack.field_190927_a);
        this.output = output;
        for (int i = 0; i < 9; ++i) {
            ItemStack temp = input.size() > i ? input.get(i) : null;
            if (temp instanceof ItemStack) {
                this.inputs.add(temp.func_77946_l());
            } else if (temp instanceof Item) {
                this.inputs.add(new ItemStack((IItemProvider)((Item)temp)));
            } else if (temp instanceof Block) {
                this.inputs.add(new ItemStack((IItemProvider)((Block)temp)));
            } else {
                this.inputs.add(ItemStack.field_190927_a);
            }
            if (this.inputs.get(i).func_190926_b()) continue;
            this.nonEmptyIndices.add(i);
        }
        assert (this.inputs.size() == 9);
    }

    public String toString() {
        return "input=" + this.inputs + "\toutput=" + this.output;
    }

    public List<ItemStack> getEmptyStrippedInputs() {
        return this.inputs.stream().filter(x -> !x.func_190926_b()).collect(Collectors.toList());
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191196_a();
    }

    public boolean matchesHandlerStacks(CustomStackHandler handler) {
        int matchingStacks = 0;
        for (int index = 0; index < this.inputs.size(); ++index) {
            ItemStack recipeStack = this.inputs.get(index);
            ItemStack handlerStack = handler.getStackInSlot(index);
            if ((handlerStack.func_77973_b() == Ref.slotFiller || handlerStack.func_190926_b()) && recipeStack.func_190926_b()) {
                ++matchingStacks;
                continue;
            }
            if (handlerStack.func_190926_b() || recipeStack.func_190926_b() || !StackUtils.areStacksEqualIgnoreQuantity(handlerStack, recipeStack) || handlerStack.func_190916_E() < recipeStack.func_190916_E()) continue;
            ++matchingStacks;
        }
        return matchingStacks == 9;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Ref.COMBINER_SERIALIZER;
    }
}

