/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.combiner;

import al132.alchemistry.RecipeTypes;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.combiner.CombinerRecipe;
import al132.alchemistry.utils.IItemHandlerUtils;
import al132.alchemistry.utils.StackUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CombinerRegistry {
    private static List<CombinerRecipe> recipes = null;
    private static HashMap<List<ItemStack>, CombinerRecipe> inputCache = new HashMap();
    private static HashMap<ItemStack, CombinerRecipe> outputCache = new HashMap();

    public static List<CombinerRecipe> getRecipes(World world) {
        if (recipes == null) {
            recipes = world.func_199532_z().func_199510_b().stream().filter(x -> x.func_222127_g() == RecipeTypes.COMBINER).map(x -> (CombinerRecipe)x).collect(Collectors.toList());
        }
        return recipes;
    }

    public static CombinerRecipe matchOutput(World world, ItemStack stack) {
        CombinerRecipe cacheResult = outputCache.getOrDefault(stack, null);
        if (cacheResult != null) {
            return cacheResult;
        }
        CombinerRecipe recipe = CombinerRegistry.getRecipes(world).stream().filter(it -> it.output.func_77973_b() == stack.func_77973_b()).filter(it -> ItemStack.func_77989_b((ItemStack)it.output, (ItemStack)stack)).findFirst().orElse(null);
        outputCache.put(stack, recipe);
        return recipe;
    }

    public static CombinerRecipe matchInputs(World world, IItemHandler handler) {
        return CombinerRegistry.matchInputs(world, IItemHandlerUtils.toStackList(handler));
    }

    private static CombinerRecipe matchInputs(World world, List<ItemStack> inputStacks) {
        CombinerRecipe cacheResult = inputCache.getOrDefault(inputStacks, null);
        if (cacheResult != null) {
            return cacheResult;
        }
        block0: for (CombinerRecipe recipe : CombinerRegistry.getRecipes(world)) {
            boolean matchingStacks = false;
            for (int index = 0; index < recipe.inputs.size(); ++index) {
                ItemStack recipeStack = recipe.inputs.get(index);
                ItemStack inputStack = inputStacks.get(index);
                if ((inputStack.func_77973_b() != Ref.slotFiller && !inputStack.func_190926_b() || !recipeStack.func_190926_b()) && (!StackUtils.areStacksEqualIgnoreQuantity(inputStack, recipeStack) || inputStack.func_190916_E() < recipeStack.func_190916_E() || inputStack.func_190926_b() || recipeStack.func_190926_b())) continue block0;
            }
            inputCache.put(inputStacks, recipe);
            return recipe;
        }
        return null;
    }
}

