/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.dissolver;

import al132.alchemistry.RecipeTypes;
import al132.alchemistry.blocks.dissolver.DissolverRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class DissolverRegistry {
    private static List<DissolverRecipe> recipes = null;
    private static HashMap<ItemStack, DissolverRecipe> cache = new HashMap();

    public static List<DissolverRecipe> getRecipes(World world) {
        if (recipes == null) {
            recipes = world.func_199532_z().func_199510_b().stream().filter(x -> x.func_222127_g() == RecipeTypes.DISSOLVER).map(x -> (DissolverRecipe)x).collect(Collectors.toList());
        }
        return recipes;
    }

    @Nullable
    public static DissolverRecipe match(World world, ItemStack input, boolean quantitySensitive) {
        DissolverRecipe cachedRecipe = cache.getOrDefault(input, null);
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        for (DissolverRecipe recipe : DissolverRegistry.getRecipes(world)) {
            if (recipe.inputIngredient == null) continue;
            for (ItemStack recipeStack : (ItemStack[])recipe.inputIngredient.ingredient.func_193365_a().clone()) {
                if (!ItemStack.func_179545_c((ItemStack)recipeStack, (ItemStack)input) || (!quantitySensitive || input.func_190916_E() < recipeStack.func_190916_E()) && quantitySensitive) continue;
                cachedRecipe = recipe.copy();
                cache.put(input, cachedRecipe);
                return cachedRecipe;
            }
        }
        return null;
    }
}

