/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.datagen.recipe;

import al132.alchemistry.Ref;
import al132.alchemistry.datagen.recipe.BaseRecipeBuilder;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;

public class FissionRecipeBuilder
extends BaseRecipeBuilder {
    private int input;
    private String group = "minecraft:misc";
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();

    public static FissionRecipeBuilder recipe(int input) {
        return new FissionRecipeBuilder(input);
    }

    public FissionRecipeBuilder(int inputNumber) {
        this.input = inputNumber;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        String name = Integer.toString(this.input);
        this.build(consumerIn, new ResourceLocation("alchemistry", "fission/" + name));
    }

    @Override
    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.group == null ? "" : this.group, this.input, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.input + "/" + id.func_110623_a())));
    }

    @Override
    void validate(ResourceLocation id) {
    }

    public static class Result
    implements IFinishedRecipe {
        private final String group;
        private final ResourceLocation id;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementID;
        private final int input;

        public Result(ResourceLocation id, String group, int input, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.input = input;
            this.advancementBuilder = advancementBuilder;
            this.advancementID = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("input", (Number)this.input);
            if (this.input % 2 == 0) {
                json.addProperty("output", (Number)(this.input / 2));
                json.addProperty("output2", (Number)(this.input / 2));
            } else {
                json.addProperty("output", (Number)(this.input / 2 + 1));
                json.addProperty("output2", (Number)(this.input / 2));
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return Ref.FISSION_SERIALIZER;
        }

        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        public ResourceLocation func_200443_d() {
            return this.advancementID;
        }
    }
}

