/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class UpgradedGateBlock
extends FurnitureHorizontalWaterloggedBlock {
    public static final EnumProperty<DoorHingeSide> HINGE = EnumProperty.func_177709_a((String)"hinge", DoorHingeSide.class);
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty DOUBLE = BooleanProperty.func_177716_a((String)"double");
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public final ImmutableMap<BlockState, VoxelShape> COLLISION_SHAPES;

    public UpgradedGateBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOUBLE, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a(), false);
        this.COLLISION_SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a(), true);
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states, boolean collision) {
        VoxelShape[] RIGHT_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.5, (double)1.0, (double)7.0, (double)14.5, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_DOUBLE_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)1.0, (double)7.0, (double)14.0, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)13.0, (double)1.0, (double)-5.0, (double)15.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] RIGHT_DOUBLE_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)13.0, (double)1.0, (double)-6.0, (double)15.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] RIGHT_HINGE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)14.0, (double)3.0, (double)7.0, (double)15.0, (double)6.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_HINGE_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)14.0, (double)12.0, (double)7.0, (double)15.0, (double)15.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_POST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)15.0, (double)0.0, (double)6.0, (double)18.0, (double)17.0, (double)10.0), Direction.SOUTH));
        VoxelShape[] LEFT_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.5, (double)1.0, (double)7.0, (double)14.5, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_DOUBLE_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)2.0, (double)1.0, (double)7.0, (double)16.0, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)1.0, (double)-5.0, (double)3.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] LEFT_DOUBLE_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)1.0, (double)-6.0, (double)3.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] LEFT_HINGE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)3.0, (double)7.0, (double)2.0, (double)6.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_HINGE_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)12.0, (double)7.0, (double)2.0, (double)15.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_POST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)-2.0, (double)0.0, (double)6.0, (double)1.0, (double)17.0, (double)10.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            DoorHingeSide hingeSide = (DoorHingeSide)state.func_177229_b(HINGE);
            boolean open = (Boolean)state.func_177229_b((Property)OPEN);
            boolean double_ = (Boolean)state.func_177229_b((Property)DOUBLE);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            switch (hingeSide) {
                case LEFT: {
                    VoxelShape doubleGate;
                    VoxelShape post = LEFT_POST[direction.func_176736_b()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                    shapes.add(LEFT_HINGE_BOTTOM[direction.func_176736_b()]);
                    shapes.add(LEFT_HINGE_TOP[direction.func_176736_b()]);
                    if (open) {
                        VoxelShape voxelShape = doubleGate = double_ ? LEFT_DOUBLE_GATE_OPEN[direction.func_176736_b()] : LEFT_GATE_OPEN[direction.func_176736_b()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    } else {
                        VoxelShape voxelShape = doubleGate = double_ ? LEFT_DOUBLE_GATE_CLOSED[direction.func_176736_b()] : LEFT_GATE_CLOSED[direction.func_176736_b()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    }
                    if (double_) break;
                    post = RIGHT_POST[direction.func_176736_b()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                    break;
                }
                case RIGHT: {
                    VoxelShape doubleGate;
                    VoxelShape post = RIGHT_POST[direction.func_176736_b()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                    shapes.add(RIGHT_HINGE_BOTTOM[direction.func_176736_b()]);
                    shapes.add(RIGHT_HINGE_TOP[direction.func_176736_b()]);
                    if (open) {
                        VoxelShape voxelShape = doubleGate = double_ ? RIGHT_DOUBLE_GATE_OPEN[direction.func_176736_b()] : RIGHT_GATE_OPEN[direction.func_176736_b()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    } else {
                        VoxelShape voxelShape = doubleGate = double_ ? RIGHT_DOUBLE_GATE_CLOSED[direction.func_176736_b()] : RIGHT_GATE_CLOSED[direction.func_176736_b()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    }
                    if (double_) break;
                    post = LEFT_POST[direction.func_176736_b()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.COLLISION_SHAPES.get((Object)state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        Direction hitFace = result.func_216354_b();
        Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
        boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        if (hitFace.func_176740_k() != direction.func_176740_k() && (!open || hitFace.func_176740_k().func_200128_b())) {
            return ActionResultType.PASS;
        }
        DoorHingeSide hingeSide = (DoorHingeSide)state.func_177229_b(HINGE);
        this.openGate(state, (IWorld)world, pos, direction, hitFace, !open);
        this.openDoubleGate((IWorld)world, pos, direction, hitFace, hingeSide, !open);
        this.openAdjacentGate((IWorld)world, pos, direction, Direction.UP, hitFace, hingeSide, !open, 5);
        this.openAdjacentGate((IWorld)world, pos, direction, Direction.DOWN, hitFace, hingeSide, !open, 5);
        world.func_217378_a(playerEntity, !open ? 1008 : 1014, pos, 0);
        return ActionResultType.SUCCESS;
    }

    private void openGate(BlockState state, IWorld world, BlockPos pos, Direction direction, Direction hitFace, boolean open) {
        if (open) {
            if (hitFace.func_176734_d() == direction) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            } else if (hitFace == direction) {
                world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open))).func_206870_a(HINGE, (Comparable)this.getOppositeHinge((DoorHingeSide)state.func_177229_b(HINGE)))).func_206870_a((Property)DIRECTION, (Comparable)hitFace.func_176734_d()), 3);
            }
        } else {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void openAdjacentGate(IWorld world, BlockPos pos, Direction direction, Direction offset, Direction hitFace, DoorHingeSide hingeSide, boolean open, int limit) {
        if (limit <= 0) {
            return;
        }
        BlockPos offsetPos = pos.func_177972_a(offset);
        BlockState state = world.func_180495_p(offsetPos);
        if (state.func_177230_c() == this) {
            if (state.func_177229_b((Property)DIRECTION) != direction || state.func_177229_b(HINGE) != hingeSide || (Boolean)state.func_177229_b((Property)OPEN) == open) {
                return;
            }
            this.openGate(state, world, offsetPos, direction, hitFace, open);
            this.openDoubleGate(world, offsetPos, direction, hitFace, hingeSide, open);
            this.openAdjacentGate(world, offsetPos, direction, offset, hitFace, hingeSide, open, limit - 1);
        }
    }

    private void openDoubleGate(IWorld world, BlockPos pos, Direction direction, Direction hitFace, DoorHingeSide hingeSide, boolean open) {
        BlockPos adjacentPos = pos.func_177972_a(hingeSide == DoorHingeSide.LEFT ? direction.func_176746_e() : direction.func_176735_f());
        BlockState adjacentState = world.func_180495_p(adjacentPos);
        if (adjacentState.func_177230_c() == this && ((Direction)adjacentState.func_177229_b((Property)DIRECTION)).func_176740_k() == direction.func_176740_k()) {
            if (adjacentState.func_177229_b(HINGE) != hingeSide) {
                this.openGate(adjacentState, world, adjacentPos, direction, hitFace, open);
            } else {
                this.openGate((BlockState)((BlockState)adjacentState.func_206870_a((Property)DIRECTION, (Comparable)((Direction)adjacentState.func_177229_b((Property)DIRECTION)).func_176734_d())).func_206870_a(HINGE, (Comparable)this.getOppositeHinge((DoorHingeSide)adjacentState.func_177229_b(HINGE))), world, adjacentPos, direction, hitFace, open);
            }
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a(HINGE, (Comparable)this.getHingeSide(context));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        Direction facing = (Direction)state.func_177229_b((Property)DIRECTION);
        Direction offset = state.func_177229_b(HINGE) == DoorHingeSide.LEFT ? facing.func_176746_e() : facing.func_176735_f();
        BlockState adjacentBlock = world.func_180495_p(pos.func_177972_a(offset));
        return (BlockState)state.func_206870_a((Property)DOUBLE, (Comparable)Boolean.valueOf(adjacentBlock.func_177230_c() == this));
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext context) {
        Direction playerFacing = context.func_195992_f();
        int offsetX = playerFacing.func_82601_c();
        int offsetZ = playerFacing.func_82599_e();
        BlockPos pos = context.func_195995_a();
        Vector3d hitVec = context.func_221532_j().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        boolean side = offsetX < 0 && hitVec.field_72449_c < 0.5 || offsetX > 0 && hitVec.field_72449_c > 0.5 || offsetZ < 0 && hitVec.field_72450_a > 0.5 || offsetZ > 0 && hitVec.field_72450_a < 0.5;
        return side ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
    }

    private DoorHingeSide getOppositeHinge(DoorHingeSide hingeSide) {
        return hingeSide == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HINGE});
        builder.func_206894_a(new Property[]{OPEN});
        builder.func_206894_a(new Property[]{DOUBLE});
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return (Boolean)state.func_177229_b((Property)OPEN) == false ? PathNodeType.FENCE : PathNodeType.OPEN;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.func_201670_d()) {
            boolean powered = world.func_175640_z(pos);
            if ((Boolean)state.func_177229_b((Property)POWERED) != powered) {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 2);
                if ((Boolean)state.func_177229_b((Property)OPEN) != powered) {
                    world.func_217378_a(null, powered ? 1008 : 1014, pos, 0);
                }
            }
        }
    }
}

