/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.energystorage;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class EnergyStorageItemBlockEnergyContainer
implements IEnergyStorageCapacity,
IEnergyStorageMutable {
    private final ItemBlockEnergyContainer itemBlockEnergyContainer;
    private final ItemStack itemStack;
    private final int rate;

    public EnergyStorageItemBlockEnergyContainer(ItemBlockEnergyContainer itemBlockEnergyContainer, ItemStack itemStack, int rate) {
        this.itemBlockEnergyContainer = itemBlockEnergyContainer;
        this.itemStack = itemStack;
        this.rate = rate;
        if (!this.itemStack.func_77942_o()) {
            this.setItemStackEnergy(itemStack, 0);
        }
    }

    public EnergyStorageItemBlockEnergyContainer(ItemBlockEnergyContainer itemBlockEnergyContainer, ItemStack itemStack) {
        this(itemBlockEnergyContainer, itemStack, Integer.MAX_VALUE);
    }

    public int getRate() {
        return this.rate;
    }

    public boolean isCreative() {
        IEnergyContainerBlock block = this.itemBlockEnergyContainer.get();
        return block instanceof BlockEnergyBatteryBase && ((BlockEnergyBatteryBase)block).isCreative();
    }

    protected int getEnergyStoredSingular() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        CompoundNBT tag = this.itemStack.func_196082_o();
        return tag.func_74762_e(this.itemBlockEnergyContainer.get().getEneryContainerNBTName());
    }

    public int getEnergyStored() {
        return this.getEnergyStoredSingular() * this.itemStack.func_190916_E();
    }

    public int getMaxEnergyStoredSingular() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        CompoundNBT tag = this.itemStack.func_196082_o();
        if (!tag.func_74764_b(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName())) {
            return BlockEnergyBatteryConfig.capacity;
        }
        return tag.func_74762_e(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName());
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStoredSingular() * this.itemStack.func_190916_E();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return 0;
        }
        int stackSize = this.itemStack.func_190916_E();
        energy /= stackSize;
        energy = Math.min(energy, this.getRate());
        int stored = this.getEnergyStoredSingular();
        int energyReceived = Math.min(this.getMaxEnergyStoredSingular() - stored, energy);
        if (!simulate) {
            this.setItemStackEnergy(this.itemStack, stored + energyReceived);
        }
        return energyReceived * stackSize;
    }

    public int extractEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        int stackSize = this.itemStack.func_190916_E();
        energy /= stackSize;
        energy = Math.min(energy, this.getRate());
        int stored = this.getEnergyStoredSingular();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setItemStackEnergy(this.itemStack, newEnergy);
        }
        return (stored - newEnergy) * stackSize;
    }

    protected void setItemStackEnergy(ItemStack itemStack, int energy) {
        if (this.isCreative()) {
            return;
        }
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_74768_a(this.itemBlockEnergyContainer.get().getEneryContainerNBTName(), energy);
    }

    @Override
    public void setCapacity(int capacity) {
        CompoundNBT tag = this.itemStack.func_196082_o();
        if (capacity == BlockEnergyBatteryConfig.capacity) {
            tag.func_82580_o(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName());
        } else {
            tag.func_74768_a(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName(), capacity);
        }
    }

    @Override
    public void setEnergy(int energy) {
        this.setItemStackEnergy(this.itemStack, energy);
    }
}

