/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.valuetype.IngredientsValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;

public class RecipeValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final IValueTypeWorldRenderer INGREDIENTS_RENDERER = ValueTypeWorldRenderers.REGISTRY.getRenderer(ValueTypes.OBJECT_INGREDIENTS);

    @Override
    public void renderValue(TileEntityRendererDispatcher rendererDispatcher, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        Optional recipeOptional = ((ValueObjectTypeRecipe.ValueRecipe)value).getRawValue();
        if (recipeOptional.isPresent()) {
            IRecipeDefinition recipe = (IRecipeDefinition)recipeOptional.get();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.3f, 0.3f, 1.0f);
            rendererDispatcher.func_147548_a().func_228079_a_(L10NHelpers.localize((String)"gui.integrateddynamics.input_short", (Object[])new Object[0]), 8.0f, 15.0f, Helpers.RGBToInt((int)255, (int)255, (int)255), false, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, false, 0, combinedLight);
            rendererDispatcher.func_147548_a().func_228079_a_(L10NHelpers.localize((String)"gui.integrateddynamics.output_short", (Object[])new Object[0]), 46.0f, 15.0f, Helpers.RGBToInt((int)255, (int)255, (int)255), false, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, false, 0, combinedLight);
            matrixStack.func_227865_b_();
            matrixStack.func_227861_a_(0.0, 8.333333015441895, 0.0);
            this.renderInput(rendererDispatcher, partContainer, direction, partType, recipe, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
            matrixStack.func_227861_a_(12.5, 0.0, 0.0);
            INGREDIENTS_RENDERER.renderValue(rendererDispatcher, partContainer, direction, partType, ValueObjectTypeIngredients.ValueIngredients.of(recipe.getOutput()), partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
            matrixStack.func_227865_b_();
        }
    }

    protected void renderInput(TileEntityRendererDispatcher rendererDispatcher, IPartContainer partContainer, Direction direction, IPartType partType, IRecipeDefinition recipe, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        int ingredientCount = recipe.getInputComponents().stream().mapToInt(c -> recipe.getInputs(c).size()).sum();
        ArrayList values = Lists.newArrayListWithExpectedSize((int)ingredientCount);
        int tick = (int)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 30;
        for (IngredientComponent component : recipe.getInputComponents()) {
            IIngredientMatcher matcher = component.getMatcher();
            IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
            Stream<List<IPrototypedIngredient>> inputs = this.enhanceRecipeInputs(component, recipe);
            inputs.forEach(element -> values.add(componentHandler.toValue(((IPrototypedIngredient)IngredientsValueTypeWorldRenderer.prepareElementForTick(element, tick, () -> new PrototypedIngredient(component, matcher.getEmptyInstance(), matcher.getAnyMatchCondition()))).getPrototype())));
        }
        IngredientsValueTypeWorldRenderer.renderGrid(rendererDispatcher, partContainer, direction, partType, values, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
    }

    protected <T, M> Stream<List<IPrototypedIngredient>> enhanceRecipeInputs(IngredientComponent<T, M> ingredientComponent, IRecipeDefinition recipe) {
        Stream inputs = recipe.getInputs(ingredientComponent).stream();
        if (ingredientComponent == IngredientComponent.ITEMSTACK) {
            IIngredientMatcher matcher = ingredientComponent.getMatcher();
            return inputs.map(input -> input.getAlternatives().stream().map(prototypedIngredient -> Collections.singletonList(prototypedIngredient)).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return inputs.map(p -> Lists.newArrayList((Iterable)p.getAlternatives()));
    }
}

