/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;

public class WidgetTextFieldDropdown<T>
extends WidgetTextFieldExtended {
    private Set<IDropdownEntry<T>> possibilities;
    private List<IDropdownEntry<T>> visiblePossibilities = Collections.emptyList();
    private int visiblePossibilitiesIndex = -1;
    private IDropdownEntry<T> selectedDropdownPossibility = null;
    private int dropdownSize = 5;
    private IDropdownEntryListener<T> dropdownEntryListener;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public WidgetTextFieldDropdown(FontRenderer fontrenderer, int x, int y, int width, int height, ITextComponent narrationMessage, boolean background, Set<IDropdownEntry<T>> possibilities) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.setPossibilities(Objects.requireNonNull(possibilities));
    }

    public WidgetTextFieldDropdown(FontRenderer fontrenderer, int x, int y, int width, int height, ITextComponent narrationMessage, boolean background) {
        this(fontrenderer, x, y, width, height, narrationMessage, background, Collections.emptySet());
    }

    public void setPossibilities(Set<IDropdownEntry<T>> possibilities) {
        this.possibilities = possibilities;
        this.visiblePossibilities = Collections.emptyList();
    }

    public int getPossibilitiesCount() {
        return this.possibilities.size();
    }

    @Nullable
    public IDropdownEntry<T> getVisiblePossibility(int index) {
        return this.visiblePossibilities.get(index);
    }

    protected void refreshDropdownList() {
        if (this.func_146179_b().contains("\u00a7")) {
            this.func_146180_a(this.func_146179_b().replaceAll("\u00a7.", ""));
        }
        if (!this.possibilities.isEmpty()) {
            this.visiblePossibilities = Lists.newArrayList();
            for (IDropdownEntry<T> possibility : this.possibilities) {
                if (!possibility.getMatchString().toLowerCase().contains(this.func_146179_b().toLowerCase())) continue;
                this.visiblePossibilities.add(possibility);
            }
            this.visiblePossibilitiesIndex = -1;
            if (!this.visiblePossibilities.isEmpty()) {
                this.selectedDropdownPossibility = this.visiblePossibilities.stream().filter(e -> e.getMatchString().equals(this.func_146179_b())).findFirst().orElse(null);
            }
            if (this.dropdownEntryListener != null) {
                this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
            }
        }
    }

    public void func_146195_b(boolean isFocusedIn) {
        super.func_146195_b(isFocusedIn);
        if (isFocusedIn) {
            this.refreshDropdownList();
        }
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (super.func_231042_a_(typedChar, keyCode)) {
            this.refreshDropdownList();
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int typedChar, int keyCode, int modifiers) {
        this.selectedDropdownPossibility = null;
        if (!this.possibilities.isEmpty()) {
            switch (typedChar) {
                case 265: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex >= 0 ? --this.visiblePossibilitiesIndex : this.visiblePossibilities.size() - 1;
                    return true;
                }
                case 258: 
                case 264: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex < this.visiblePossibilities.size() - 1 ? ++this.visiblePossibilitiesIndex : 0;
                    return true;
                }
                case 257: 
                case 262: 
                case 335: {
                    if (this.visiblePossibilitiesIndex < 0 || this.visiblePossibilitiesIndex >= this.visiblePossibilities.size()) break;
                    this.selectVisiblePossibility(this.visiblePossibilitiesIndex);
                    return true;
                }
            }
        }
        if (super.func_231046_a_(typedChar, keyCode, modifiers)) {
            this.refreshDropdownList();
            return true;
        }
        return false;
    }

    protected void selectVisiblePossibility(int index) {
        this.visiblePossibilitiesIndex = index;
        this.selectPossibility(this.visiblePossibilities.get(this.visiblePossibilitiesIndex));
    }

    public void selectPossibility(@Nullable IDropdownEntry<T> entry) {
        this.selectedDropdownPossibility = entry;
        this.func_146180_a(this.selectedDropdownPossibility != null ? this.selectedDropdownPossibility.getDisplayString().getString() : "");
        this.visiblePossibilities = Lists.newArrayList();
        this.visiblePossibilitiesIndex = -1;
        if (this.dropdownEntryListener != null) {
            this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
        }
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_146193_g(this.selectedDropdownPossibility == null ? Helpers.RGBToInt((int)220, (int)10, (int)10) : 0xE0E0E0);
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.func_146176_q() && this.func_230999_j_()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
            fontRenderer.getClass();
            int yOffset = 9 + 3;
            int x = this.field_230690_l_;
            int y = this.field_230691_m_ + yOffset;
            int width = this.func_230998_h_() + 9;
            int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
            int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
            int cy = y;
            if (startIndex > 0) {
                WidgetTextFieldDropdown.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)(cy - 1), (int)(x + width), (int)(cy + 11), (int)-6250336);
                WidgetTextFieldDropdown.func_238467_a_((MatrixStack)matrixStack, (int)(x - 1), (int)cy, (int)(x + width - 1), (int)(cy + 10), (int)-16777216);
                fontRenderer.func_238405_a_(matrixStack, "...", (float)x + 1.0f, (float)cy + 2.0f, this.disabledColor);
                cy += 10;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                IDropdownEntry<T> dropdownEntry = this.visiblePossibilities.get(i);
                IFormattableTextComponent possibility = dropdownEntry.getDisplayString();
                List displayPossibility = fontRenderer.func_238425_b_((ITextProperties)possibility, width);
                boolean active = this.visiblePossibilitiesIndex == i;
                int entryHeight = yOffset;
                boolean addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.func_230998_h_(), (int)yOffset, (double)mouseX, (double)mouseY);
                List<IFormattableTextComponent> tooltipLines = null;
                if (addTooltip) {
                    tooltipLines = dropdownEntry.getTooltip();
                    entryHeight += tooltipLines.size() * yOffset;
                }
                WidgetTextFieldDropdown.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)(cy - 1), (int)(x + width), (int)(cy + entryHeight + 1), (int)-6250336);
                WidgetTextFieldDropdown.func_238467_a_((MatrixStack)matrixStack, (int)(x - 1), (int)cy, (int)(x + width - 1), (int)(cy + entryHeight), (int)-16777216);
                fontRenderer.func_238407_a_(matrixStack, (IReorderingProcessor)displayPossibility.get(0), (float)x + 1.0f, (float)cy + 2.0f, active ? this.enabledColor : this.disabledColor);
                if (addTooltip) {
                    int tooltipLineOffsetY = 2;
                    for (ITextComponent iTextComponent : tooltipLines) {
                        fontRenderer.func_238405_a_(matrixStack, iTextComponent.getString(), (float)x + 1.0f, (float)cy + (float)(tooltipLineOffsetY += yOffset), this.enabledColor);
                    }
                }
                cy += entryHeight;
            }
            if (endIndex < this.visiblePossibilities.size()) {
                WidgetTextFieldDropdown.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)(cy - 1), (int)(x + width), (int)(cy + 11), (int)-6250336);
                WidgetTextFieldDropdown.func_238467_a_((MatrixStack)matrixStack, (int)(x - 1), (int)cy, (int)(x + width - 1), (int)(cy + 10), (int)-16777216);
                fontRenderer.func_238405_a_(matrixStack, "...", (float)x + 1.0f, (float)cy + 2.0f, this.disabledColor);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        int i;
        if (this.func_146176_q() && this.func_230999_j_() && (i = this.getHoveredVisiblePossibility(mouseX, mouseY)) >= 0) {
            this.selectVisiblePossibility(i);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public int getHoveredVisiblePossibility(double mouseX, double mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        fontRenderer.getClass();
        int yOffset = 9 + 3;
        int x = this.field_230690_l_;
        int y = this.field_230691_m_ + yOffset;
        int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
        int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
        int cy = y;
        if (startIndex > 0) {
            cy += 10;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            boolean addTooltip;
            IDropdownEntry<T> dropdownEntry = this.visiblePossibilities.get(i);
            boolean active = this.visiblePossibilitiesIndex == i;
            int entryHeight = yOffset;
            boolean bl = addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.func_230998_h_(), (int)yOffset, (double)mouseX, (double)mouseY);
            if (RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.func_230998_h_(), (int)yOffset, (double)mouseX, (double)mouseY)) {
                return i;
            }
            List<IFormattableTextComponent> tooltipLines = null;
            if (addTooltip) {
                tooltipLines = dropdownEntry.getTooltip();
                entryHeight += tooltipLines.size() * yOffset;
            }
            cy += entryHeight;
        }
        return -1;
    }

    public IDropdownEntry<T> getSelectedDropdownPossibility() {
        return this.selectedDropdownPossibility;
    }

    public int getDropdownSize() {
        return this.dropdownSize;
    }

    public void setDropdownSize(int dropdownSize) {
        this.dropdownSize = dropdownSize;
    }

    public IDropdownEntryListener<T> getDropdownEntryListener() {
        return this.dropdownEntryListener;
    }

    public void setDropdownEntryListener(IDropdownEntryListener<T> dropdownEntryListener) {
        this.dropdownEntryListener = dropdownEntryListener;
    }
}

