/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeString
extends ValueTypeBase<ValueString>
implements IValueTypeNamed<ValueString> {
    public ValueTypeString() {
        super("string", Helpers.RGBToInt((int)250, (int)10, (int)13), TextFormatting.RED, ValueString.class);
    }

    @Override
    public ValueString getDefault() {
        return ValueString.of("");
    }

    @Override
    public IFormattableTextComponent toCompactString(ValueString value) {
        return new StringTextComponent(value.getRawValue());
    }

    @Override
    public INBT serialize(ValueString value) {
        return StringNBT.func_229705_a_((String)value.getRawValue());
    }

    @Override
    public ValueString deserialize(INBT value) {
        return ValueString.of(value.func_150285_a_());
    }

    @Override
    public String toString(ValueString value) {
        return value.getRawValue();
    }

    @Override
    public ValueString parseString(String value) throws EvaluationException {
        return ValueString.of(value);
    }

    @Override
    public String getName(ValueString a) {
        return a.getRawValue();
    }

    public static class ValueString
    extends ValueBase {
        private final String value;

        private ValueString(String value) {
            super(ValueTypes.STRING);
            this.value = value;
        }

        public static ValueString of(String value) {
            return new ValueString(value);
        }

        public String getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueString && ((ValueString)o).value.equals(this.value);
        }

        public int hashCode() {
            return this.getType().hashCode() + this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeString.ValueString(value=" + this.value + ")";
        }
    }
}

