/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;

public final class Helpers {
    public static final Predicate<Entity> SELECTOR_IS_PLAYER = entity -> entity instanceof PlayerEntity;
    private static final List<IInterfaceRetriever> INTERFACE_RETRIEVERS = Lists.newArrayList();

    public static FluidStack getFluidStack(ItemStack itemStack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        if (fluidStack.isEmpty() && itemStack.func_77973_b() instanceof BlockItem && ((BlockItem)itemStack.func_77973_b()).func_179223_d() instanceof IFluidBlock) {
            fluidStack = new FluidStack(((IFluidBlock)((BlockItem)itemStack.func_77973_b()).func_179223_d()).getFluid(), 1000);
        }
        return fluidStack;
    }

    public static int getFluidStackCapacity(ItemStack itemStack) {
        IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (fluidHandler != null && fluidHandler.getTanks() > 0) {
            return fluidHandler.getTankCapacity(0);
        }
        return 0;
    }

    public static Stream<ItemStack> getTagValues(String name) throws ResourceLocationException {
        ITag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(name));
        if (tag == null) {
            return Stream.empty();
        }
        return tag.func_230236_b_().stream().map(ItemStack::new);
    }

    public static <T> List<T> joinList(List<T> list, T newElement) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(list);
        if (newElement != null) {
            builder.add(newElement);
        }
        return builder.build();
    }

    public static String createPatternOfLength(int length) {
        StringBuilder pattern = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < length; ++i) {
            if (first) {
                first = false;
            } else {
                pattern.append(",");
            }
            pattern.append("%s");
        }
        return pattern.toString();
    }

    private static <C> Optional<C> getInterface(IBlockReader world, BlockPos pos, Class<C> clazz) {
        for (IInterfaceRetriever interfaceRetriever : INTERFACE_RETRIEVERS) {
            Optional<C> optionalInstance = interfaceRetriever.getInterface(world, pos, clazz);
            if (!optionalInstance.isPresent()) continue;
            return optionalInstance;
        }
        return Optional.empty();
    }

    public static <C> Optional<C> getInterface(DimPos dimPos, Class<C> clazz, boolean forceLoad) {
        World world = dimPos.getWorld(forceLoad);
        return world != null ? Helpers.getInterface((IBlockReader)world, dimPos.getBlockPos(), clazz) : Optional.empty();
    }

    public static ITextComponent getLocalizedEnergyLevel(int stored, int capacity) {
        return new StringTextComponent(String.format("%,d", stored)).func_240702_b_(" / ").func_240702_b_(String.format("%,d", capacity)).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("general.integrateddynamics.energy_unit"));
    }

    public static void addInterfaceRetriever(IInterfaceRetriever interfaceRetriever) {
        INTERFACE_RETRIEVERS.add(interfaceRetriever);
    }

    public static <T extends Exception, R> R sneakyThrow(Exception t) throws T {
        throw t;
    }

    static {
        Helpers.addInterfaceRetriever(TileHelpers::getSafeTile);
    }

    public static interface IInterfaceRetriever {
        public <C> Optional<C> getInterface(IBlockReader var1, BlockPos var2, Class<C> var3);
    }
}

