/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public abstract class ContainerMultipart<P extends IPartType<P, S>, S extends IPartState<P>>
extends InventoryContainer
implements IDirtyMarkListener {
    public static final String BUTTON_SETTINGS = "button_settings";
    private static final int PAGE_SIZE = 3;
    private final Optional<PartTarget> target;
    private final Optional<IPartContainer> partContainer;
    private final P partType;
    private final World world;

    public ContainerMultipart(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, IInventory inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, P partType) {
        super(type, id, playerInventory, inventory);
        this.target = target;
        this.partType = partType;
        this.partContainer = partContainer;
        this.world = this.player.func_130014_f_();
        this.putButtonAction(BUTTON_SETTINGS, (s, containerExtended) -> {
            if (!this.world.func_201670_d()) {
                PartHelpers.openContainerPart((ServerPlayerEntity)this.player, ((PartTarget)target.get()).getCenter(), partType);
            }
        });
    }

    public World getWorld() {
        return this.world;
    }

    public P getPartType() {
        return this.partType;
    }

    public Optional<PartTarget> getTarget() {
        return this.target;
    }

    public Optional<S> getPartState() {
        return this.partContainer.map(p -> p.getPartState(this.getTarget().get().getCenter().getSide()));
    }

    public Optional<IPartContainer> getPartContainer() {
        return this.partContainer;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return PartHelpers.canInteractWith(this.getTarget().get(), this.player, this.partContainer.get());
    }

    public void onDirty() {
    }
}

