/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.capability.valueinterface.ValueInterfaceConfig;
import org.cyclops.integrateddynamics.capability.valueinterface.ValueInterfaceDefault;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateBase;

public abstract class PartStateActiveVariableBase<P extends IPartType>
extends PartStateBase<P> {
    private boolean checkedForWriteVariable = false;
    protected IVariableFacade currentVariableFacade = null;
    private final IVariableContainer variableContainer;
    private boolean deactivated = false;
    private SimpleInventory inventory;
    private List<IFormattableTextComponent> globalErrorMessages = Lists.newLinkedList();

    public PartStateActiveVariableBase(int inventorySize) {
        this.inventory = new SingularInventory(inventorySize);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.variableContainer = new VariableContainerDefault();
        this.addVolatileCapability(VariableContainerConfig.CAPABILITY, LazyOptional.of(() -> this.variableContainer));
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    protected void validate(IPartNetwork network) {
        this.currentVariableFacade.validate(network, new Validator(this), this.currentVariableFacade.getOutputType());
    }

    protected void onCorruptedState() {
        IntegratedDynamics.clog(Level.ERROR, "A corrupted part state was found at, repairing...");
        Thread.dumpStack();
        this.checkedForWriteVariable = false;
        this.deactivated = true;
    }

    public boolean hasVariable() {
        return this.getGlobalErrors().isEmpty() && !this.getInventory().func_191420_l();
    }

    public <V extends IValue> IVariable<V> getVariable(INetwork network, IPartNetwork partNetwork) {
        if (!this.checkedForWriteVariable) {
            if (this.variableContainer.getVariableCache().isEmpty()) {
                this.variableContainer.refreshVariables(network, (IInventory)this.inventory, false);
            }
            for (IVariableFacade facade : this.variableContainer.getVariableCache().values()) {
                if (facade == null) continue;
                this.currentVariableFacade = facade;
                this.validate(partNetwork);
            }
            this.checkedForWriteVariable = true;
        }
        if (this.currentVariableFacade == null) {
            this.onCorruptedState();
            return null;
        }
        return this.currentVariableFacade.getVariable(partNetwork);
    }

    public void onVariableContentsUpdated(P partType, PartTarget target) {
        this.checkedForWriteVariable = false;
        this.addGlobalError(null);
        this.currentVariableFacade = null;
        PartPos center = target.getCenter();
        NetworkHelpers.getNetwork((IBlockReader)center.getPos().getWorld(true), center.getPos().getBlockPos(), center.getSide()).ifPresent(network -> this.variableContainer.refreshVariables((INetwork)network, (IInventory)this.inventory, false));
    }

    public List<IFormattableTextComponent> getGlobalErrors() {
        return this.globalErrorMessages;
    }

    public void addGlobalError(IFormattableTextComponent error) {
        if (error == null) {
            this.globalErrorMessages.clear();
        } else {
            this.globalErrorMessages.add(error);
        }
        this.onDirty();
        this.sendUpdate();
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        NBTClassType.writeNbt(List.class, (String)"globalErrorMessages", this.globalErrorMessages, (CompoundNBT)tag);
        this.inventory.writeToNBT(tag, "inventory");
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.globalErrorMessages = (List)NBTClassType.readNbt(List.class, (String)"globalErrorMessages", (CompoundNBT)tag);
        this.inventory.readFromNBT(tag, "inventory");
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == ValueInterfaceConfig.CAPABILITY) {
            IVariable variable;
            if (this.hasVariable() && (variable = this.getVariable(network, partNetwork)) != null) {
                return LazyOptional.of(() -> {
                    try {
                        return new ValueInterfaceDefault((IValue)variable.getValue());
                    }
                    catch (EvaluationException e) {
                        return new ValueInterfaceDefault((IValue)variable.getType().getDefault());
                    }
                }).cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, network, partNetwork, target);
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(boolean deactivated) {
        this.deactivated = deactivated;
    }

    public static class Validator
    implements IVariableFacade.IValidator {
        private final PartStateActiveVariableBase state;

        public Validator(PartStateActiveVariableBase state) {
            this.state = state;
        }

        @Override
        public void addError(IFormattableTextComponent error) {
            this.state.addGlobalError(error);
        }
    }

    public static class SingularInventory
    extends SimpleInventory {
        public SingularInventory(int size) {
            super(size, 1);
        }

        protected boolean canInsert(int slot) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (i == slot || this.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return this.canInsert(i) && super.func_94041_b(i, itemstack);
        }
    }
}

