/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class SqueezerRecipeAppendix
extends RecipeAppendix<RecipeSqueezer> {
    private static final int SLOT_INPUT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int SLOT_OUTPUT_OFFSET_X = 68;
    private static final AdvancedButtonEnum INPUT_ITEM = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT_FLUID = AdvancedButtonEnum.create();
    private final List<AdvancedButtonEnum> resultItems = Lists.newArrayList();

    public SqueezerRecipeAppendix(IInfoBook infoBook, RecipeSqueezer recipe) {
        super(infoBook, (Object)recipe);
        for (int i = 0; i < recipe.getOutputItems().size(); ++i) {
            this.resultItems.add(AdvancedButtonEnum.create());
        }
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return (((RecipeSqueezer)this.recipe).getOutputFluid() != null ? 23 : 0) + this.resultItems.size() * 23 - 3;
    }

    protected String getUnlocalizedTitle() {
        return "block.integrateddynamics.squeezer";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT_ITEM, new RecipeAppendix.ItemButton(this.getInfoBook()));
        for (AdvancedButtonEnum resultItem : this.resultItems) {
            this.renderItemHolders.put(resultItem, new RecipeAppendix.ItemButton(this.getInfoBook()));
        }
        this.renderItemHolders.put(RESULT_FLUID, new RecipeAppendix.FluidButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, MatrixStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(matrixStack, x + middle - 3, y + 2);
        int tick = this.getTick(gui);
        ItemStack inputItem = ((RecipeSqueezer)this.recipe).getInputIngredient() == null ? null : this.prepareItemStacks(((RecipeSqueezer)this.recipe).getInputIngredient().func_193365_a(), tick);
        List outputItems = ((RecipeSqueezer)this.recipe).getOutputItems().stream().map(RecipeSqueezer.ItemStackChance::getItemStack).collect(Collectors.toList());
        FluidStack outputFluid = ((RecipeSqueezer)this.recipe).getOutputFluid();
        this.renderItem(gui, matrixStack, x + 16, y, inputItem, mx, my, INPUT_ITEM);
        int slotOffset = 0;
        for (int i = 0; i < outputItems.size(); ++i) {
            this.renderItem(gui, matrixStack, x + 68, y + slotOffset, (ItemStack)outputItems.get(i), mx, my, this.resultItems.get(i), ((RecipeSqueezer.ItemStackChance)((RecipeSqueezer)this.recipe).getOutputItems().get(i)).getChance());
            slotOffset += 23;
        }
        if (outputFluid != null) {
            this.renderFluid(gui, matrixStack, x + 68, y + slotOffset, outputFluid, mx, my, RESULT_FLUID);
        }
        this.renderItem(gui, matrixStack, x + middle, y, this.getCrafter(), mx, my, false, null);
    }

    protected ItemStack getCrafter() {
        return new ItemStack((IItemProvider)RegistryEntries.BLOCK_SQUEEZER);
    }
}

