/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanelVariableDriven;

public class ContainerPartPanelVariableDriven<P extends PartTypePanelVariableDriven<P, S>, S extends PartTypePanelVariableDriven.State<P, S>>
extends ContainerMultipart<P, S> {
    private static final int SLOT_X = 79;
    private static final int SLOT_Y = 8;
    private final int readValueId = this.getNextValueId();
    private final int readColorId = this.getNextValueId();
    private final int readErrorsId = this.getNextValueId();

    public ContainerPartPanelVariableDriven(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, (IInventory)new Inventory(packetBuffer.readInt()), Optional.empty(), Optional.empty(), (PartTypePanelVariableDriven)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartPanelVariableDriven(int id, PlayerInventory playerInventory, IInventory inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, P partType) {
        super(RegistryEntries.CONTAINER_PART_DISPLAY, id, playerInventory, inventory, target, partContainer, partType);
        if (inventory instanceof SimpleInventory) {
            ((SimpleInventory)inventory).addDirtyMarkListener((IDirtyMarkListener)this);
        }
        this.addInventory(inventory, 0, 80, 14, 1, 1);
        this.addPlayerInventory(this.player.field_71071_by, 8, 46);
    }

    protected Slot createNewSlot(IInventory inventory, int index, int x, int y) {
        if (inventory instanceof SimpleInventory) {
            return new SlotVariable(inventory, index, x, y);
        }
        return super.createNewSlot(inventory, index, x, y);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.field_70170_p.func_201670_d()) {
            StringTextComponent readValue = new StringTextComponent("");
            int readValueColor = 0;
            if (!NetworkHelpers.shouldWork()) {
                readValue = new StringTextComponent("SAFE-MODE");
            } else {
                IValue value = ((PartTypePanelVariableDriven.State)this.getPartState().get()).getDisplayValue();
                if (value != null) {
                    readValue = value.getType().toCompactString(value);
                    readValueColor = value.getType().getDisplayColor();
                }
            }
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readValueId, (IFormattableTextComponent)readValue);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readColorId, (int)readValueColor);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readErrorsId, ((PartTypePanelVariableDriven.State)this.getPartState().get()).getGlobalErrors());
        }
    }

    @Override
    public void onDirty() {
        if (!this.player.field_70170_p.func_201670_d()) {
            PartTypePanelVariableDriven.State partState = (PartTypePanelVariableDriven.State)this.getPartState().get();
            partState.onVariableContentsUpdated(this.getPartType(), this.getTarget().get());
            LazyOptional<INetwork> optionalNetwork = NetworkHelpers.getNetwork(this.getTarget().get().getCenter());
            if (!this.getContainerInventory().func_191420_l()) {
                NetworkHelpers.getPartNetwork(optionalNetwork).ifPresent(partNetwork -> {
                    try {
                        INetwork network = (INetwork)optionalNetwork.orElse(null);
                        IVariable variable = partState.getVariable(network, (IPartNetwork)partNetwork);
                        MinecraftForge.EVENT_BUS.post(new PartVariableDrivenVariableContentsUpdatedEvent(network, (IPartNetwork)partNetwork, this.getTarget().get(), this.getPartType(), partState, this.player, variable, variable != null ? (IValue)variable.getValue() : null));
                    }
                    catch (EvaluationException evaluationException) {
                        // empty catch block
                    }
                });
            }
            optionalNetwork.ifPresent(network -> network.getEventBus().post(new VariableContentsUpdatedEvent((INetwork)network)));
        }
    }

    public void func_75134_a(PlayerEntity player) {
        if (this.inventory instanceof SimpleInventory) {
            ((SimpleInventory)this.inventory).removeDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    public ITextComponent getReadValue() {
        return ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.readValueId);
    }

    public int getReadValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.readColorId);
    }

    public List<IFormattableTextComponent> getReadErrors() {
        return ValueNotifierHelpers.getValueTextComponentList((IValueNotifier)this, (int)this.readErrorsId);
    }
}

