/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public class ActionLabelPacket
extends PacketCodec {
    @CodecField
    private int variableId;
    @CodecField
    private String label;

    public ActionLabelPacket() {
    }

    public ActionLabelPacket(int variableId, String label) {
        this.variableId = variableId;
        this.label = label;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
        if (this.label == null) {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).removeUnsafe(this.variableId);
        } else {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).putUnsafe(this.variableId, this.label);
        }
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        if (this.label == null) {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).remove(this.variableId);
        } else {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).put(this.variableId, this.label);
        }
    }
}

