/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class TileSqueezer
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private final SimpleInventory inventory = new SimpleInventory(1, 1){

        public boolean func_94041_b(int slot, ItemStack itemStack) {
            return (Integer)TileSqueezer.this.func_145831_w().func_180495_p(TileSqueezer.this.func_174877_v()).func_177229_b((Property)BlockSqueezer.HEIGHT) == 1 && this.func_70301_a(0).func_190926_b() && super.func_94041_b(slot, itemStack);
        }

        public void func_70299_a(int slotId, ItemStack itemstack) {
            super.func_70299_a(slotId, itemstack);
            TileSqueezer.this.itemHeight = 1;
            TileSqueezer.this.sendUpdate();
        }
    };
    private final SingleUseTank tank = new SingleUseTank(1000);
    @NBTPersist
    private int itemHeight = 1;
    private SingleCache<ItemStack, Optional<RecipeSqueezer>> recipeCache;

    public TileSqueezer() {
        super(RegistryEntries.TILE_ENTITY_SQUEEZER);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((SimpleInventory)this.getInventory()).getItemHandler()));
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, LazyOptional.of(() -> new SimpleInventoryState(this.getInventory())));
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(this::getTank));
        this.inventory.addDirtyMarkListener(() -> ((TileSqueezer)this).sendUpdate());
        this.tank.addDirtyMarkListener(() -> ((SimpleInventory)this.inventory).func_70296_d());
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<ItemStack, Optional<RecipeSqueezer>>(){

            public Optional<RecipeSqueezer> getNewValue(ItemStack key) {
                Inventory recipeInput = new Inventory(new ItemStack[]{key});
                return CraftingHelpers.findServerRecipe(TileSqueezer.this.getRegistry(), (IInventory)recipeInput, (World)TileSqueezer.this.func_145831_w());
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.func_77989_b((ItemStack)cacheKey, (ItemStack)newKey);
            }
        });
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerSqueezer(() -> ((TileSqueezer)this).func_145831_w())));
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void read(CompoundNBT tag) {
        this.inventory.readFromNBT(tag, "inventory");
        this.tank.readFromNBT(tag, "tank");
        super.read(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.writeToNBT(tag, "inventory");
        this.tank.writeToNBT(tag, "tank");
        return super.func_189515_b(tag);
    }

    protected IRecipeType<RecipeSqueezer> getRegistry() {
        return RegistryEntries.RECIPETYPE_SQUEEZER;
    }

    public Optional<RecipeSqueezer> getCurrentRecipe() {
        return (Optional)this.recipeCache.get((Object)this.getInventory().func_70301_a(0).func_77946_l());
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K) {
            Optional<RecipeSqueezer> recipeOptional;
            if (!this.getTank().isEmpty()) {
                Direction.Axis axis = (Direction.Axis)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockSqueezer.AXIS);
                Arrays.stream(Direction.AxisDirection.values()).map(axisDirection -> Direction.func_181076_a((Direction.AxisDirection)axisDirection, (Direction.Axis)axis)).forEach(side -> {
                    if (!this.getTank().isEmpty()) {
                        TileHelpers.getCapability((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side), (Direction)side.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                            FluidStack fluidStack = new FluidStack(this.getTank().getFluid(), Math.min(100, this.getTank().getFluidAmount()));
                            if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
                                int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                                this.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            }
                        });
                    }
                });
            } else if (this.itemHeight == 7 && (recipeOptional = this.getCurrentRecipe()).isPresent()) {
                RecipeSqueezer recipe = recipeOptional.get();
                this.getInventory().func_70299_a(0, ItemStack.field_190927_a);
                for (RecipeSqueezer.ItemStackChance itemStackChance : recipe.getOutputItems()) {
                    if (itemStackChance.getChance() != 1.0f && !(itemStackChance.getChance() >= this.func_145831_w().field_73012_v.nextFloat())) continue;
                    ItemStack resultStack = itemStackChance.getItemStack().func_77946_l();
                    for (Direction side2 : Direction.values()) {
                        IItemHandler itemHandler;
                        if (resultStack.func_190926_b() || side2 == Direction.UP || (itemHandler = (IItemHandler)TileHelpers.getCapability((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side2), (Direction)side2.func_176734_d(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) == null) continue;
                        resultStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)resultStack, (boolean)false);
                    }
                    if (resultStack.func_190926_b()) continue;
                    ItemStackHelpers.spawnItemStack((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)resultStack);
                }
                if (!recipe.getOutputFluid().isEmpty()) {
                    this.getTank().fill(recipe.getOutputFluid(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
        this.sendUpdate();
        this.getInventory().func_70296_d();
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

