/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderSettings;
import mcjty.lib.varia.MathTools;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.fluids.FluidStack;

public class RenderHelper {
    public static float rot = 0.0f;
    public static final int MAX_BRIGHTNESS = 0xF000F0;
    public static final RenderSettings DEFAULT_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(128).build();

    public static void renderEntity(MatrixStack matrixStack, Entity entity, int xPos, int yPos) {
        float f1 = 10.0f;
        RenderHelper.renderEntity(matrixStack, entity, xPos, yPos, f1);
    }

    public static void adjustTransformToDirection(MatrixStack matrixStack, Direction facing) {
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        switch (facing) {
            case DOWN: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case UP: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                break;
            }
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            }
        }
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
    }

    public static void renderNorthSouthQuad(IVertexBuilder builder, Matrix4f matrix, TextureAtlasSprite sprite, ModelBuilder.FaceRotation rotation, float offset) {
        switch (rotation) {
            case ZERO: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.func_94209_e(), sprite.func_94210_h());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.func_94212_f(), sprite.func_94210_h());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.func_94212_f(), sprite.func_94206_g());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.func_94209_e(), sprite.func_94206_g());
                break;
            }
            case CLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.func_94212_f(), sprite.func_94206_g());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.func_94209_e(), sprite.func_94206_g());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.func_94209_e(), sprite.func_94210_h());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.func_94212_f(), sprite.func_94210_h());
                break;
            }
            case UPSIDE_DOWN: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.func_94209_e(), sprite.func_94206_g());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.func_94209_e(), sprite.func_94210_h());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.func_94212_f(), sprite.func_94210_h());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.func_94212_f(), sprite.func_94206_g());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.func_94212_f(), sprite.func_94210_h());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.func_94212_f(), sprite.func_94206_g());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.func_94209_e(), sprite.func_94206_g());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.func_94209_e(), sprite.func_94210_h());
            }
        }
    }

    public static void renderEntity(MatrixStack matrixStack, Entity entity, int xPos, int yPos, float scale) {
        matrixStack.func_227860_a_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227623_K_();
        GlStateManager.func_227725_h_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(xPos + 8), (double)(yPos + 16), 50.0);
        matrixStack.func_227862_a_(-scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(135.0f));
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(135.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot));
        entity.field_70125_A = 0.0f;
        matrixStack.func_227861_a_(0.0, (double)((float)entity.func_70033_W()), 0.0);
        matrixStack.func_227865_b_();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_227624_L_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227623_K_();
        int i1 = 240;
        int k1 = 240;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227624_L_();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227731_j_();
        matrixStack.func_227865_b_();
    }

    public static boolean renderObject(MatrixStack matrixStack, int x, int y, Object itm, boolean highlight) {
        if (itm instanceof Entity) {
            RenderHelper.renderEntity(matrixStack, (Entity)itm, x, y);
            return true;
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        return RenderHelper.renderObject(matrixStack, itemRenderer, x, y, itm, highlight, 100.0f);
    }

    public static boolean renderObject(MatrixStack matrixStack, ItemRenderer itemRender, int x, int y, Object itm, boolean highlight, float lvl) {
        itemRender.field_77023_b = lvl;
        if (itm == null) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, ItemStack.field_190927_a, x, y, "", highlight);
        }
        if (itm instanceof Item) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, new ItemStack((IItemProvider)((Item)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof Block) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, new ItemStack((IItemProvider)((Block)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof ItemStack) {
            return RenderHelper.renderItemStackWithCount(matrixStack, itemRender, (ItemStack)itm, x, y, highlight);
        }
        if (itm instanceof FluidStack) {
            return RenderHelper.renderFluidStack((FluidStack)itm, x, y, highlight);
        }
        if (itm instanceof TextureAtlasSprite) {
            return RenderHelper.renderIcon(matrixStack, itemRender, (TextureAtlasSprite)itm, x, y, highlight);
        }
        return RenderHelper.renderItemStack(matrixStack, itemRender, ItemStack.field_190927_a, x, y, "", highlight);
    }

    public static boolean renderIcon(MatrixStack matrixStack, ItemRenderer itemRender, TextureAtlasSprite itm, int xo, int yo, boolean highlight) {
        return true;
    }

    public static boolean renderFluidStack(FluidStack fluidStack, int x, int y, boolean highlight) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        ResourceLocation fluidStill = fluid.getAttributes().getStillTexture();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStill);
        }
        if (fluidStillSprite == null) {
            return false;
        }
        int fluidColor = fluid.getAttributes().getColor(fluidStack);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(AtlasTexture.field_110575_b);
        RenderHelper.setGLColorFromInt(fluidColor);
        RenderHelper.drawFluidTexture(x, y, fluidStillSprite, 100.0);
        return true;
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, double zLevel) {
        float uMin = textureSprite.func_94209_e();
        float uMax = textureSprite.func_94212_f();
        float vMin = textureSprite.func_94206_g();
        float vMax = textureSprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_225582_a_(xCoord, yCoord + 16.0, zLevel).func_225583_a_(uMin, vMax).func_181675_d();
        vertexBuffer.func_225582_a_(xCoord + 16.0, yCoord + 16.0, zLevel).func_225583_a_(uMax, vMax).func_181675_d();
        vertexBuffer.func_225582_a_(xCoord + 16.0, yCoord, zLevel).func_225583_a_(uMax, vMin).func_181675_d();
        vertexBuffer.func_225582_a_(xCoord, yCoord, zLevel).func_225583_a_(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_227702_d_((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static boolean renderItemStackWithCount(MatrixStack matrixStack, ItemRenderer itemRender, ItemStack itm, int xo, int yo, boolean highlight) {
        int size = itm.func_190916_E();
        String amount = size <= 1 ? "" : (size < 100000 ? String.valueOf(size) : (size < 1000000 ? String.valueOf(size / 1000) + "k" : (size < 1000000000 ? String.valueOf(size / 1000000) + "m" : String.valueOf(size / 1000000000) + "g")));
        return RenderHelper.renderItemStack(matrixStack, itemRender, itm, xo, yo, amount, highlight);
    }

    public static void renderStackOnGround(MatrixStack matrixStack, ItemStack stack, double alpha) {
        if (!stack.func_190926_b()) {
            IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
            if (!stack.func_190926_b()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha));
                GlStateManager.func_227623_K_();
                GlStateManager.func_227639_a_((int)516, (float)0.1f);
                GlStateManager.func_227740_m_();
                GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
                matrixStack.func_227860_a_();
                matrixStack.func_227865_b_();
                GlStateManager.func_227624_L_();
                GlStateManager.func_227737_l_();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).restoreLastBlurMipmap();
            }
        }
    }

    public static boolean renderItemStack(MatrixStack matrixStack, ItemRenderer itemRender, ItemStack itm, int x, int y, String txt, boolean highlight) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = false;
        if (highlight) {
            RenderSystem.disableLighting();
            RenderHelper.drawVerticalGradientRect(x, y, x + 16, y + 16, -2130706433, -1);
        }
        if (!itm.func_190926_b() && itm.func_77973_b() != null) {
            rc = true;
            matrixStack.func_227860_a_();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableLighting();
            net.minecraft.client.renderer.RenderHelper.func_227780_a_();
            RenderSystem.glMultiTexCoord2f((int)33985, (float)240.0f, (float)240.0f);
            itemRender.func_180450_b(itm, x, y);
            RenderHelper.renderItemOverlayIntoGUI(matrixStack, Minecraft.func_71410_x().field_71466_p, itm, x, y, txt, txt.length() - 2);
            matrixStack.func_227865_b_();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableLighting();
        }
        return rc;
    }

    private static void renderItemOverlayIntoGUI(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixStack.func_227861_a_(0.0, 0.0, (double)(itemRenderer.field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                if (scaled >= 2) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                    fr.func_238405_a_(matrixStack, s, (float)((xPosition + 19 - 2) * 2 - 1 - fr.func_78256_a(s)), (float)(yPosition * 2 + 24), 0xFFFFFF);
                    matrixStack.func_227865_b_();
                } else if (scaled == 1) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                    fr.func_238405_a_(matrixStack, s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.func_78256_a(s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF);
                    matrixStack.func_227865_b_();
                } else {
                    fr.func_238405_a_(matrixStack, s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                }
                buffer.func_228461_a_();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                RenderHelper.draw(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(bufferbuilder, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                RenderHelper.draw(bufferbuilder1, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void renderItemOverlayIntoGUIOld(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity PlayerEntitysp;
            float f;
            int stackSize = stack.func_190916_E();
            if (stackSize != 1 || text != null) {
                String s;
                String string = s = text == null ? String.valueOf(stackSize) : text;
                if (text == null && stackSize < 1) {
                    s = TextFormatting.RED + String.valueOf(stackSize);
                }
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                if (scaled >= 2) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                    fr.func_238405_a_(matrixStack, s, (float)((xPosition + 19 - 2) * 2 - 1 - fr.func_78256_a(s)), (float)(yPosition * 2 + 24), 0xFFFFFF);
                    matrixStack.func_227865_b_();
                } else if (scaled == 1) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                    fr.func_238405_a_(matrixStack, s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.func_78256_a(s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF);
                    matrixStack.func_227865_b_();
                } else {
                    fr.func_238405_a_(matrixStack, s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                }
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int j = (int)Math.round(13.0 - health * 13.0);
                int i = (int)Math.round(255.0 - health * 255.0);
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer = tessellator.func_178180_c();
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, j, 1, 255 - i, i, 0, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
            }
            float f2 = f = (PlayerEntitysp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : PlayerEntitysp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f > 0.0f) {
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer1 = tessellator1.func_178180_c();
                RenderHelper.draw(vertexbuffer1, xPosition, yPosition + MathTools.floor(16.0f * (1.0f - f)), 16, MathTools.ceiling(16.0f * f), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_((double)(x + 0), (double)(y + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + 0), (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)(y + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawVerticalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        GlStateManager.func_227621_I_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227700_d_();
        GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        GlStateManager.func_227762_u_((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x2, (double)y1, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y1, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y2, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227762_u_((int)7424);
        GlStateManager.func_227737_l_();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227619_H_();
    }

    public static void drawHorizontalGradientRect(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        GlStateManager.func_227621_I_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227700_d_();
        GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        GlStateManager.func_227762_u_((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x1, (double)y1, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y2, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227762_u_((int)7424);
        GlStateManager.func_227737_l_();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227619_H_();
    }

    public static void drawHorizontalGradientRect(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x1, int y1, int x2, int y2, int color1, int color2, int lightmap) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        IVertexBuilder builder = buffer.getBuffer(CustomRenderTypes.QUADS_NOTEXTURE);
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(positionMatrix, (float)x1, (float)y1, zLevel).func_227885_a_(f1, f2, f3, f).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)x1, (float)y2, zLevel).func_227885_a_(f1, f2, f3, f).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)x2, (float)y2, zLevel).func_227885_a_(f5, f6, f7, f4).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)x2, (float)y1, zLevel).func_227885_a_(f5, f6, f7, f4).func_227886_a_(lightmap).func_181675_d();
    }

    public static void drawHorizontalLine(MatrixStack matrixStack, int x1, int y1, int x2, int color) {
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawVerticalLine(MatrixStack matrixStack, int x1, int y1, int y2, int color) {
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    public static void drawLeftTriangle(MatrixStack matrixStack, int x, int y, int color) {
        RenderHelper.drawVerticalLine(matrixStack, x, y, y, color);
        RenderHelper.drawVerticalLine(matrixStack, x + 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(matrixStack, x + 2, y - 2, y + 2, color);
    }

    public static void drawRightTriangle(MatrixStack matrixStack, int x, int y, int color) {
        RenderHelper.drawVerticalLine(matrixStack, x, y, y, color);
        RenderHelper.drawVerticalLine(matrixStack, x - 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(matrixStack, x - 2, y - 2, y + 2, color);
    }

    public static void drawUpTriangle(MatrixStack matrixStack, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(matrixStack, x, y, x, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 1, y + 1, x + 1, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 2, y + 2, x + 2, color);
    }

    public static void drawDownTriangle(MatrixStack matrixStack, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(matrixStack, x, y, x, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 1, y - 1, x + 1, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 2, y - 2, x + 2, color);
    }

    public static void drawColorLogic(int x, int y, int width, int height, int red, int green, int blue, GlStateManager.LogicOp colorLogic) {
        GlStateManager.func_227621_I_();
        GlStateManager.func_227615_F_();
        GlStateManager.func_227753_q_((int)colorLogic.field_187370_q);
        RenderHelper.draw(Tessellator.func_178181_a().func_178180_c(), x, y, width, height, red, green, blue, 255);
        GlStateManager.func_227617_G_();
        GlStateManager.func_227619_H_();
    }

    public static void drawThickButtonBox(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 2), (int)(y1 + 2), (int)(x2 - 2), (int)(y2 - 2), (int)average);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 1, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 2, y1 + 2, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 2, y1 + 3, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 3, y2 - 3, x2 - 2, dark);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 2, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 2, y2 - 2, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 3, y1 + 3, y2 - 3, dark);
    }

    public static void drawThinButtonBox(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)average);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawThinButtonBoxGradient(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawFlatButtonBox(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        RenderHelper.drawBeveledBox(matrixStack, x1, y1, x2, y2, bright, dark, average);
    }

    public static void drawFlatButtonBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x1, int y1, int x2, int y2, int bright, int average, int dark, int lightmap) {
        RenderHelper.drawBeveledBox(matrixStack, buffer, x1, y1, x2, y2, bright, dark, average, lightmap);
    }

    public static void drawFlatButtonBoxGradient(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, bright);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, dark);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, dark);
    }

    public static void drawBeveledBox(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, botrightcolor);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, botrightcolor);
    }

    public static void drawBeveledBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor, int lightmap) {
        if (fillcolor != -1) {
            RenderHelper.fill(matrixStack, buffer, x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor, lightmap);
        }
        RenderHelper.fill(matrixStack, buffer, x1, y1, x2 - 1, y1 + 1, topleftcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x1, y1, x1 + 1, y2 - 1, topleftcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x2 - 1, y1, x2 - 1 + 1, y2 - 1, botrightcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x1, y2 - 1, x2, y2 - 1 + 1, botrightcolor, lightmap);
    }

    public static void drawThickBeveledBox(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawFlatBox(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int border, int fill) {
        if (fill != -1) {
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fill);
        }
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, border);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, border);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, border);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, border);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)(x + 0), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + 0), (double)zLevel).func_225583_a_((float)(u + width) * f, (float)(v + 0) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + 0), (double)(y + 0), (double)zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int totw, int toth) {
        float f = 1.0f / (float)totw;
        float f1 = 1.0f / (float)toth;
        double zLevel = 50.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + height), zLevel).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + height) * f1).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_((float)(textureX + width) * f, (float)(textureY + height) * f1).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + 0), zLevel).func_225583_a_((float)(textureX + width) * f, (float)(textureY + 0) * f1).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + 0), zLevel).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(Matrix4f positionMatrix, IVertexBuilder builder, int x, int y, int textureX, int textureY, int width, int height, int totw, int toth, float parentU, float parentV) {
        float f = 1.0f / (float)totw;
        float f1 = 1.0f / (float)toth;
        float zLevel = 50.0f;
        builder.func_227888_a_(positionMatrix, (float)(x + 0), (float)(y + height), zLevel).func_225583_a_(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + height) * f1).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)(x + width), (float)(y + height), zLevel).func_225583_a_(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + height) * f1).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)(x + width), (float)(y + 0), zLevel).func_225583_a_(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + 0) * f1).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)(x + 0), (float)(y + 0), zLevel).func_225583_a_(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + 0) * f1).func_181675_d();
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + height), zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + 0), zLevel).func_225583_a_((float)(u + width) * f, (float)(v + 0) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + 0), zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderBillboardQuadBright(MatrixStack matrixStack, IRenderTypeBuffer buffer, float scale, ResourceLocation texture) {
        RenderHelper.renderBillboardQuadBright(matrixStack, buffer, scale, texture, DEFAULT_SETTINGS);
    }

    public static void renderBillboardQuadBright(MatrixStack matrixStack, IRenderTypeBuffer buffer, float scale, ResourceLocation texture, RenderSettings settings) {
        int b1 = settings.getBrightness() >> 16 & 0xFFFF;
        int b2 = settings.getBrightness() & 0xFFFF;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        RenderHelper.rotateToPlayer(matrixStack);
        IVertexBuilder builder = buffer.getBuffer(settings.getRenderType());
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(matrix, -scale, -scale, 0.0f).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_225587_b_(b1, b2).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, -scale, scale, 0.0f).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_225587_b_(b1, b2).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, scale, scale, 0.0f).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_225587_b_(b1, b2).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, scale, -scale, 0.0f).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_225587_b_(b1, b2).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        matrixStack.func_227865_b_();
    }

    public static void rotateToPlayer(MatrixStack matrixStack) {
        Quaternion rotation = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_227995_f_();
        matrixStack.func_227863_a_(rotation);
    }

    public static int renderText(MatrixStack matrixStack, int x, int y, String txt) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 32.0);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227623_K_();
        GlStateManager.func_227716_f_();
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227731_j_();
        GlStateManager.func_227737_l_();
        Minecraft mc = Minecraft.func_71410_x();
        int width = mc.field_71466_p.func_78256_a(txt);
        mc.field_71466_p.func_238405_a_(matrixStack, txt, (float)x, (float)y, 0xFFFFFF);
        GlStateManager.func_227716_f_();
        GlStateManager.func_227734_k_();
        GlStateManager.func_227740_m_();
        matrixStack.func_227865_b_();
        GlStateManager.func_227624_L_();
        GlStateManager.func_227722_g_();
        return width;
    }

    public static int renderText(MatrixStack matrixStack, int x, int y, String txt, int color) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 32.0);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227623_K_();
        GlStateManager.func_227716_f_();
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227731_j_();
        GlStateManager.func_227737_l_();
        Minecraft mc = Minecraft.func_71410_x();
        int width = mc.field_71466_p.func_78256_a(txt);
        mc.field_71466_p.func_238421_b_(matrixStack, txt, (float)x, (float)y, color);
        GlStateManager.func_227716_f_();
        GlStateManager.func_227734_k_();
        GlStateManager.func_227740_m_();
        matrixStack.func_227865_b_();
        GlStateManager.func_227624_L_();
        GlStateManager.func_227722_g_();
        return width;
    }

    public static void drawBeam(Vector S, Vector E, Vector P, float width) {
        Vector PS = RenderHelper.Sub(S, P);
        Vector SE = RenderHelper.Sub(E, S);
        Vector normal = RenderHelper.Cross(PS, SE);
        normal = normal.normalize();
        Vector half = RenderHelper.Mul(normal, width);
        Vector p1 = RenderHelper.Add(S, half);
        Vector p2 = RenderHelper.Sub(S, half);
        Vector p3 = RenderHelper.Add(E, half);
        Vector p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(Tessellator.func_178181_a(), p1, p3, p4, p2, DEFAULT_SETTINGS);
    }

    public static void drawBeam(Matrix4f matrix, IVertexBuilder builder, TextureAtlasSprite sprite, Vector S, Vector E, Vector P, float width) {
        Vector PS = RenderHelper.Sub(S, P);
        Vector SE = RenderHelper.Sub(E, S);
        Vector normal = RenderHelper.Cross(PS, SE);
        normal = normal.normalize();
        Vector half = RenderHelper.Mul(normal, width);
        Vector p1 = RenderHelper.Add(S, half);
        Vector p2 = RenderHelper.Sub(S, half);
        Vector p3 = RenderHelper.Add(E, half);
        Vector p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(matrix, builder, sprite, p1, p3, p4, p2, DEFAULT_SETTINGS);
    }

    public static void drawBeam(Vector S, Vector E, Vector P, RenderSettings settings) {
        Vector PS = RenderHelper.Sub(S, P);
        Vector SE = RenderHelper.Sub(E, S);
        Vector normal = RenderHelper.Cross(PS, SE);
        normal = normal.normalize();
        Vector half = RenderHelper.Mul(normal, settings.getWidth());
        Vector p1 = RenderHelper.Add(S, half);
        Vector p2 = RenderHelper.Sub(S, half);
        Vector p3 = RenderHelper.Add(E, half);
        Vector p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(Tessellator.func_178181_a(), p1, p3, p4, p2, settings);
    }

    private static void drawQuad(Tessellator tessellator, Vector p1, Vector p2, Vector p3, Vector p4, RenderSettings settings) {
        int b1 = settings.getBrightness() >> 16 & 0xFFFF;
        int b2 = settings.getBrightness() & 0xFFFF;
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_225582_a_((double)p1.getX(), (double)p1.getY(), (double)p1.getZ()).func_225583_a_(0.0f, 0.0f).func_225587_b_(b1, b2).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_181675_d();
        buffer.func_225582_a_((double)p2.getX(), (double)p2.getY(), (double)p2.getZ()).func_225583_a_(1.0f, 0.0f).func_225587_b_(b1, b2).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_181675_d();
        buffer.func_225582_a_((double)p3.getX(), (double)p3.getY(), (double)p3.getZ()).func_225583_a_(1.0f, 1.0f).func_225587_b_(b1, b2).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_181675_d();
        buffer.func_225582_a_((double)p4.getX(), (double)p4.getY(), (double)p4.getZ()).func_225583_a_(0.0f, 1.0f).func_225587_b_(b1, b2).func_225586_a_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).func_181675_d();
    }

    public static void drawBeam(Matrix4f matrix, IVertexBuilder buffer, TextureAtlasSprite sprite, Vector S, Vector E, Vector P, RenderSettings settings) {
        Vector PS = RenderHelper.Sub(S, P);
        Vector SE = RenderHelper.Sub(E, S);
        Vector normal = RenderHelper.Cross(PS, SE);
        normal = normal.normalize();
        Vector half = RenderHelper.Mul(normal, settings.getWidth());
        Vector p1 = RenderHelper.Add(S, half);
        Vector p2 = RenderHelper.Sub(S, half);
        Vector p3 = RenderHelper.Add(E, half);
        Vector p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(matrix, buffer, sprite, p1, p3, p4, p2, settings);
    }

    private static void drawQuad(Matrix4f matrix, IVertexBuilder buffer, TextureAtlasSprite sprite, Vector p1, Vector p2, Vector p3, Vector p4, RenderSettings settings) {
        int b1 = settings.getBrightness() >> 16 & 0xFFFF;
        int b2 = settings.getBrightness() & 0xFFFF;
        RenderHelper.vt(buffer, matrix, p1.getX(), p1.getY(), p1.getZ(), sprite.func_94209_e(), sprite.func_94206_g(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        RenderHelper.vt(buffer, matrix, p2.getX(), p2.getY(), p2.getZ(), sprite.func_94212_f(), sprite.func_94206_g(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        RenderHelper.vt(buffer, matrix, p3.getX(), p3.getY(), p3.getZ(), sprite.func_94212_f(), sprite.func_94210_h(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        RenderHelper.vt(buffer, matrix, p4.getX(), p4.getY(), p4.getZ(), sprite.func_94209_e(), sprite.func_94210_h(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
    }

    public static void vt(IVertexBuilder renderer, Matrix4f matrix, float x, float y, float z, float u, float v) {
        renderer.func_227888_a_(matrix, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u, v).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static void vt(IVertexBuilder renderer, Matrix4f matrix, float x, float y, float z, float u, float v, int lu, int lv, int r, int g, int b, int a) {
        renderer.func_227888_a_(matrix, x, y, z).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_225587_b_(lu, lv).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    private static Vector Cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    private static Vector Sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector Add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector Mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    public static void renderHighLightedBlocksOutline(IVertexBuilder buffer, Matrix4f positionMatrix, float mx, float my, float mz, float r, float g, float b, float a) {
        buffer.func_227888_a_(positionMatrix, mx, my, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my + 1.0f, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my + 1.0f, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my + 1.0f, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my + 1.0f, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my + 1.0f, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my + 1.0f, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my + 1.0f, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my + 1.0f, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my + 1.0f, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my + 1.0f, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my + 1.0f, mz).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx + 1.0f, my, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, mx, my + 1.0f, mz + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void fill(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x1, int y1, int x2, int y2, int color, int lightmap) {
        int swapper;
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        if (x1 < x2) {
            swapper = x1;
            x1 = x2;
            x2 = swapper;
        }
        if (y1 < y2) {
            swapper = y1;
            y1 = y2;
            y2 = swapper;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        IVertexBuilder builder = buffer.getBuffer(CustomRenderTypes.QUADS_NOTEXTURE);
        builder.func_227888_a_(positionMatrix, (float)x1, (float)y2, -1.0f).func_227885_a_(r, g, b, a).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)x2, (float)y2, -1.0f).func_227885_a_(r, g, b, a).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)x2, (float)y1, -1.0f).func_227885_a_(r, g, b, a).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)x1, (float)y1, -1.0f).func_227885_a_(r, g, b, a).func_227886_a_(lightmap).func_181675_d();
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static Vector Vector(float x, float y, float z) {
            return new Vector(x, y, z);
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

