/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import javax.annotation.Nonnull;
import mcjty.lib.multipart.IPartBlock;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class MultipartItemBlock
extends BlockItem {
    public MultipartItemBlock(Block block) {
        super(block, new Item.Properties());
    }

    public MultipartItemBlock(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean func_195944_a(BlockItemUseContext context, BlockState state) {
        return true;
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack itemstack = context.func_195996_i();
        if (itemstack.func_190926_b()) {
            return ActionResultType.FAIL;
        }
        BlockState toPlace = this.func_179223_d().func_196258_a(context);
        PartSlot slot = PartSlot.NONE;
        if (this.func_179223_d() instanceof IPartBlock) {
            slot = ((IPartBlock)this.func_179223_d()).getSlotFromState(world, pos, toPlace);
        }
        if (!block.func_196253_a(state, context) && !this.canFitInside(block, world, pos, slot)) {
            pos = pos.func_177972_a(context.func_196000_l());
            state = world.func_180495_p(pos);
            block = state.func_177230_c();
        }
        if (player.func_175151_a(pos, context.func_196000_l(), itemstack)) {
            toPlace = this.func_179223_d().func_196258_a(context);
            if (this.func_179223_d() instanceof IPartBlock) {
                slot = ((IPartBlock)this.func_179223_d()).getSlotFromState(world, pos, toPlace);
            }
            if (this.canFitInside(block, world, pos, slot)) {
                if (this.placeBlockAtInternal(itemstack, player, world, pos, toPlace, slot)) {
                    SoundType soundtype = toPlace.func_177230_c().getSoundType(toPlace, (IWorldReader)world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            if (this.placeBlockAtInternal(itemstack, player, world, pos, toPlace, slot)) {
                SoundType soundtype = toPlace.func_177230_c().getSoundType(toPlace, (IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    private boolean canFitInside(Block block, World world, BlockPos pos, PartSlot slot) {
        if (block != Registration.MULTIPART_BLOCK) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE.Part part = ((MultipartTE)te).getParts().get((Object)slot);
            return part == null;
        }
        return false;
    }

    private TileEntity createTileEntity(World world, BlockState state) {
        return state.func_177230_c().createTileEntity(state, (IBlockReader)world);
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        return false;
    }

    private boolean placeBlockAtInternal(ItemStack stack, PlayerEntity player, World world, BlockPos pos, BlockState newState, @Nonnull PartSlot slot) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            TileEntity tileEntity = this.createTileEntity(world, newState);
            if (!(tileEntity instanceof GenericTileEntity) || stack.func_77978_p() != null) {
                // empty if block
            }
            ((MultipartTE)te).addPart(slot, newState, tileEntity);
            return true;
        }
        BlockState multiState = Registration.MULTIPART_BLOCK.func_176223_P();
        if (!world.func_180501_a(pos, multiState, 19)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Registration.MULTIPART_BLOCK) {
            MultipartItemBlock.func_179224_a((World)world, (PlayerEntity)player, (BlockPos)pos, (ItemStack)stack);
            te = world.func_175625_s(pos);
            if (te instanceof MultipartTE) {
                TileEntity tileEntity = this.createTileEntity(world, newState);
                if (!(tileEntity instanceof GenericTileEntity) || stack.func_77942_o()) {
                    // empty if block
                }
                ((MultipartTE)te).addPart(slot, newState, tileEntity);
                return true;
            }
            newState.func_177230_c().func_180633_a(world, pos, newState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
            }
        }
        return true;
    }

    private RayTraceResult getMovingObjectPositionFromPlayer(World worldIn, PlayerEntity playerIn, boolean useLiquids) {
        float pitch = playerIn.field_70125_A;
        float yaw = playerIn.field_70177_z;
        double x = playerIn.func_226277_ct_();
        double y = playerIn.func_226278_cu_() + (double)playerIn.func_70047_e();
        double z = playerIn.func_226281_cx_();
        Vector3d vec3 = new Vector3d(x, y, z);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = 5.0;
        if (playerIn instanceof ServerPlayerEntity) {
            // empty if block
        }
        Vector3d vec31 = vec3.func_72441_c((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        RayTraceContext context = new RayTraceContext(vec3, vec31, RayTraceContext.BlockMode.COLLIDER, useLiquids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, (Entity)playerIn);
        return worldIn.func_217299_a(context);
    }
}

