/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class MultipartTE
extends TileEntity {
    public static final ModelProperty<Map<PartSlot, Part>> PARTS = new ModelProperty();
    private Map<PartSlot, Part> parts = new HashMap<PartSlot, Part>();
    private int version = 0;

    public MultipartTE() {
        super(Registration.TYPE_MULTIPART);
    }

    private void dumpParts(String prefix) {
        if (this.field_145850_b.field_72995_K) {
            System.out.println("====== CLIENT(" + prefix + ") " + this.field_174879_c.toString() + " ======");
        } else {
            System.out.println("====== SERVER(" + prefix + ") " + this.field_174879_c.toString() + " ======");
        }
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            BlockState state = entry.getValue().state;
            System.out.println("    SLOT: " + entry.getKey().name() + "    " + state.func_177230_c().getRegistryName().toString());
            for (Property property : state.func_235904_r_()) {
                System.out.println("        PROP: " + property + " = " + state.func_177229_b(property));
            }
        }
    }

    public void addPart(PartSlot slot, BlockState state, TileEntity te) {
        System.out.println("MultipartTE.addPart: " + this.field_145850_b.field_72995_K);
        this.parts.put(slot, new Part(state, te));
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).onPartAdded(slot, state, this);
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.version;
            this.markDirtyClient();
        }
    }

    public void removePart(BlockState partState) {
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            if (entry.getValue().getState() != partState) continue;
            this.parts.remove((Object)entry.getKey());
            if (!this.field_145850_b.field_72995_K) {
                ++this.version;
                this.markDirtyClient();
            }
            return;
        }
    }

    public void dump() {
        if (this.field_145850_b.field_72995_K) {
            System.out.println("CLIENT: " + this.field_174879_c);
        } else {
            System.out.println("SERVER: " + this.field_174879_c);
        }
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            System.out.println("    SLOT: " + (Object)((Object)entry.getKey()));
            Part part = entry.getValue();
            BlockState state = part.getState();
            Block block = state.func_177230_c();
            Collection properties = state.func_235904_r_();
            System.out.println("        block: " + block.getRegistryName().toString());
            for (Property property : properties) {
                System.out.println("        property: " + property.func_177701_a() + " = " + state.func_177229_b(property).toString());
            }
        }
    }

    public Map<PartSlot, Part> getParts() {
        return this.parts;
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(PARTS, this.parts).build();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        int oldVersion = this.version;
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
        if (this.field_145850_b.field_72995_K && this.version != oldVersion) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, nbtTag);
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private boolean partExists(PartSlot slot, BlockState state) {
        if (this.parts.containsKey((Object)slot)) {
            return this.parts.get((Object)slot).getState().equals(state);
        }
        return false;
    }

    public void markDirtyQuick() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public void func_230337_a_(BlockState st, CompoundNBT compound) {
        super.func_230337_a_(st, compound);
        HashMap<PartSlot, Part> newparts = new HashMap<PartSlot, Part>();
        this.version = compound.func_74762_e("version");
        ListNBT list = compound.func_150295_c("parts", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tc;
            CompoundNBT tag = list.func_150305_b(i);
            PartSlot slot = PartSlot.byName(tag.func_74779_i("slot"));
            if (slot == null) continue;
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag);
            if (this.partExists(slot, state)) {
                Part part = this.parts.get((Object)slot);
                if (tag.func_74764_b("te")) {
                    tc = tag.func_74775_l("te");
                    TileEntity te = part.tileEntity;
                    if (te == null) {
                        te = state.func_177230_c().createTileEntity(state, (IBlockReader)this.field_145850_b);
                        if (te != null) {
                            te.func_226984_a_(this.field_145850_b, this.field_174879_c);
                            te.func_230337_a_(state, tc);
                            te.func_226984_a_(this.field_145850_b, this.field_174879_c);
                        }
                    } else {
                        te.func_230337_a_(state, tc);
                        te.func_174878_a(this.field_174879_c);
                    }
                }
                newparts.put(slot, part);
                continue;
            }
            TileEntity te = null;
            if (tag.func_74764_b("te")) {
                tc = tag.func_74775_l("te");
                te = state.func_177230_c().createTileEntity(state, (IBlockReader)this.field_145850_b);
                if (te != null) {
                    te.func_226984_a_(this.field_145850_b, this.field_174879_c);
                    te.func_230337_a_(state, tc);
                    te.func_226984_a_(this.field_145850_b, this.field_174879_c);
                }
            }
            Part part = new Part(state, te);
            newparts.put(slot, part);
        }
        this.parts = newparts;
    }

    public void func_226984_a_(World worldIn, BlockPos pos) {
        super.func_226984_a_(worldIn, pos);
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            if (entry.getValue().getTileEntity() == null) continue;
            entry.getValue().getTileEntity().func_226984_a_(worldIn, pos);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            PartSlot slot = entry.getKey();
            Part part = entry.getValue();
            BlockState state = part.getState();
            CompoundNBT tag = NBTUtil.func_190009_a((BlockState)state);
            tag.func_74778_a("slot", slot.name());
            TileEntity te = part.getTileEntity();
            if (te != null) {
                CompoundNBT tc = new CompoundNBT();
                tc = te.func_189515_b(tc);
                tag.func_218657_a("te", (INBT)tc);
            }
            list.add((Object)tag);
        }
        compound.func_218657_a("parts", (INBT)list);
        compound.func_74768_a("version", this.version);
        return super.func_189515_b(compound);
    }

    public static class Part {
        private final BlockState state;
        private final TileEntity tileEntity;

        public Part(BlockState state, TileEntity tileEntity) {
            this.state = state;
            this.tileEntity = tileEntity;
        }

        public BlockState getState() {
            return this.state;
        }

        public TileEntity getTileEntity() {
            return this.tileEntity;
        }
    }
}

