/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketRequestDataFromServer {
    protected BlockPos pos;
    private DimensionId type;
    protected String command;
    protected TypedMap params;
    private boolean dummy;

    public PacketRequestDataFromServer(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.type = DimensionId.fromPacket(buf);
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
        this.dummy = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        this.type.toBytes(buf);
        buf.func_180714_a(this.command);
        TypedMapTools.writeArguments(buf, this.params);
        buf.writeBoolean(this.dummy);
    }

    public PacketRequestDataFromServer(DimensionId type, BlockPos pos, String command, TypedMap params, boolean dummy) {
        this.type = type;
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dummy = dummy;
    }

    public void handle(SimpleChannel channel, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerWorld world = WorldTools.getWorld(ctx.getSender().func_130014_f_(), this.type);
            if (world.func_175667_e(this.pos)) {
                TileEntity te = world.func_175625_s(this.pos);
                if (!(te instanceof ICommandHandler)) {
                    Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                    return;
                }
                ICommandHandler commandHandler = (ICommandHandler)te;
                TypedMap result = commandHandler.executeWithResult(this.command, this.params);
                if (result == null) {
                    Logging.log("Command " + this.command + " was not handled!");
                    return;
                }
                PacketDataFromServer msg = new PacketDataFromServer(this.dummy ? null : this.pos, this.command, result);
                channel.sendTo((Object)msg, ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.setPacketHandled(true);
    }
}

