/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class TypedMapTools {
    private static Map<Type<?>, ArgumentType> typeToIndex = null;

    private static void setupTypeMapping() {
        if (typeToIndex == null) {
            typeToIndex = new HashMap();
            TypedMapTools.registerMapping(Type.STRING, ArgumentType.TYPE_STRING);
            TypedMapTools.registerMapping(Type.UUID, ArgumentType.TYPE_UUID);
            TypedMapTools.registerMapping(Type.INTEGER, ArgumentType.TYPE_INTEGER);
            TypedMapTools.registerMapping(Type.BLOCKPOS, ArgumentType.TYPE_BLOCKPOS);
            TypedMapTools.registerMapping(Type.DIMENSION_TYPE, ArgumentType.TYPE_DIMENSION_TYPE);
            TypedMapTools.registerMapping(Type.BOOLEAN, ArgumentType.TYPE_BOOLEAN);
            TypedMapTools.registerMapping(Type.DOUBLE, ArgumentType.TYPE_DOUBLE);
            TypedMapTools.registerMapping(Type.ITEMSTACK, ArgumentType.TYPE_STACK);
            TypedMapTools.registerMapping(Type.LONG, ArgumentType.TYPE_LONG);
            TypedMapTools.registerMapping(Type.STRING_LIST, ArgumentType.TYPE_STRING_LIST);
            TypedMapTools.registerMapping(Type.ITEMSTACK_LIST, ArgumentType.TYPE_ITEMSTACK_LIST);
            TypedMapTools.registerMapping(Type.POS_LIST, ArgumentType.TYPE_POS_LIST);
        }
    }

    private static void registerMapping(Type<?> type, ArgumentType argumentType) {
        typeToIndex.put(type, argumentType);
    }

    private static ArgumentType getArgumentType(Type<?> type) {
        TypedMapTools.setupTypeMapping();
        return typeToIndex.get(type);
    }

    public static TypedMap readArguments(PacketBuffer buf) {
        TypedMap.Builder args = TypedMap.builder();
        int size = buf.readInt();
        if (size != 0) {
            block14: for (int i = 0; i < size; ++i) {
                String key = buf.func_150789_c(Short.MAX_VALUE);
                ArgumentType type = ArgumentType.getType(buf.readByte());
                switch (type) {
                    case TYPE_STRING: {
                        args.put(new Key<String>(key, Type.STRING), NetworkTools.readStringUTF8(buf));
                        continue block14;
                    }
                    case TYPE_UUID: {
                        args.put(new Key<UUID>(key, Type.UUID), buf.func_179253_g());
                        continue block14;
                    }
                    case TYPE_INTEGER: {
                        args.put(new Key<Integer>(key, Type.INTEGER), buf.readInt());
                        continue block14;
                    }
                    case TYPE_LONG: {
                        args.put(new Key<Long>(key, Type.LONG), buf.readLong());
                        continue block14;
                    }
                    case TYPE_BOOLEAN: {
                        args.put(new Key<Boolean>(key, Type.BOOLEAN), buf.readBoolean());
                        continue block14;
                    }
                    case TYPE_DOUBLE: {
                        args.put(new Key<Double>(key, Type.DOUBLE), buf.readDouble());
                        continue block14;
                    }
                    case TYPE_DIMENSION_TYPE: {
                        if (buf.readBoolean()) {
                            args.put(new Key<DimensionId>(key, Type.DIMENSION_TYPE), DimensionId.fromPacket(buf));
                            continue block14;
                        }
                        args.put(new Key<DimensionId>(key, Type.DIMENSION_TYPE), null);
                        continue block14;
                    }
                    case TYPE_BLOCKPOS: {
                        if (buf.readBoolean()) {
                            args.put(new Key<BlockPos>(key, Type.BLOCKPOS), buf.func_179259_c());
                            continue block14;
                        }
                        args.put(new Key<BlockPos>(key, Type.BLOCKPOS), null);
                        continue block14;
                    }
                    case TYPE_STACK: {
                        if (buf.readBoolean()) {
                            args.put(new Key<ItemStack>(key, Type.ITEMSTACK), NetworkTools.readItemStack(buf));
                            continue block14;
                        }
                        args.put(new Key<ItemStack>(key, Type.ITEMSTACK), null);
                        continue block14;
                    }
                    case TYPE_STRING_LIST: {
                        int j;
                        int s = buf.readInt();
                        if (s == -1) {
                            args.put(new Key<List<String>>(key, Type.STRING_LIST), null);
                            continue block14;
                        }
                        ArrayList<String> list = new ArrayList<String>(s);
                        for (j = 0; j < s; ++j) {
                            list.add(NetworkTools.readStringUTF8(buf));
                        }
                        args.put(new Key<List<String>>(key, Type.STRING_LIST), list);
                        continue block14;
                    }
                    case TYPE_ITEMSTACK_LIST: {
                        int j;
                        int s = buf.readInt();
                        if (s == -1) {
                            args.put(new Key<List<ItemStack>>(key, Type.ITEMSTACK_LIST), null);
                            continue block14;
                        }
                        ArrayList<String> list = new ArrayList(s);
                        for (j = 0; j < s; ++j) {
                            list.add((String)NetworkTools.readItemStack(buf));
                        }
                        args.put(new Key<List<ItemStack>>(key, Type.ITEMSTACK_LIST), list);
                        continue block14;
                    }
                    case TYPE_POS_LIST: {
                        int j;
                        int s = buf.readInt();
                        if (s == -1) {
                            args.put(new Key<List<BlockPos>>(key, Type.POS_LIST), null);
                            continue block14;
                        }
                        ArrayList<String> list = new ArrayList(s);
                        for (j = 0; j < s; ++j) {
                            list.add((String)buf.func_179259_c());
                        }
                        args.put(new Key<List<BlockPos>>(key, Type.POS_LIST), list);
                        continue block14;
                    }
                    default: {
                        throw new RuntimeException("Unsupported type for key '" + key + "'!");
                    }
                }
            }
        }
        return args.build();
    }

    public static void writeArguments(PacketBuffer buf, TypedMap args) {
        buf.writeInt(args.size());
        block14: for (Key<?> key : args.getKeys()) {
            buf.func_180714_a(key.getName());
            ArgumentType argumentType = TypedMapTools.getArgumentType(key.getType());
            buf.writeByte(argumentType.ordinal());
            switch (argumentType) {
                case TYPE_STRING: {
                    NetworkTools.writeStringUTF8(buf, (String)args.get(key));
                    break;
                }
                case TYPE_UUID: {
                    buf.func_179252_a((UUID)args.get(key));
                    break;
                }
                case TYPE_INTEGER: {
                    buf.writeInt(((Integer)args.get(key)).intValue());
                    break;
                }
                case TYPE_DIMENSION_TYPE: {
                    DimensionId type = (DimensionId)args.get(key);
                    if (type != null) {
                        buf.writeBoolean(true);
                        type.toBytes(buf);
                        break;
                    }
                    buf.writeBoolean(false);
                    break;
                }
                case TYPE_BLOCKPOS: {
                    BlockPos pos = (BlockPos)args.get(key);
                    if (pos != null) {
                        buf.writeBoolean(true);
                        buf.func_179255_a(pos);
                        break;
                    }
                    buf.writeBoolean(false);
                    break;
                }
                case TYPE_BOOLEAN: {
                    buf.writeBoolean(((Boolean)args.get(key)).booleanValue());
                    break;
                }
                case TYPE_DOUBLE: {
                    buf.writeDouble(((Double)args.get(key)).doubleValue());
                    break;
                }
                case TYPE_STACK: {
                    ItemStack stack = (ItemStack)args.get(key);
                    if (stack != null) {
                        buf.writeBoolean(true);
                        NetworkTools.writeItemStack(buf, stack);
                        break;
                    }
                    buf.writeBoolean(false);
                    break;
                }
                case TYPE_LONG: {
                    buf.writeLong(((Long)args.get(key)).longValue());
                    break;
                }
                case TYPE_STRING_LIST: {
                    List list = (List)args.get(key);
                    if (list != null) {
                        buf.writeInt(list.size());
                        for (String s : list) {
                            NetworkTools.writeStringUTF8(buf, s);
                        }
                        continue block14;
                    }
                    buf.writeInt(-1);
                    break;
                }
                case TYPE_ITEMSTACK_LIST: {
                    List list = (List)args.get(key);
                    if (list != null) {
                        buf.writeInt(list.size());
                        for (String s : list) {
                            NetworkTools.writeItemStack(buf, (ItemStack)s);
                        }
                        continue block14;
                    }
                    buf.writeInt(-1);
                    break;
                }
                case TYPE_POS_LIST: {
                    List list = (List)args.get(key);
                    if (list != null) {
                        buf.writeInt(list.size());
                        for (String s : list) {
                            buf.func_179255_a((BlockPos)s);
                        }
                        continue block14;
                    }
                    buf.writeInt(-1);
                    break;
                }
            }
        }
    }

    static enum ArgumentType {
        TYPE_STRING(0),
        TYPE_INTEGER(1),
        TYPE_BLOCKPOS(2),
        TYPE_BOOLEAN(3),
        TYPE_DOUBLE(4),
        TYPE_STACK(5),
        TYPE_LONG(6),
        TYPE_STRING_LIST(7),
        TYPE_ITEMSTACK_LIST(8),
        TYPE_POS_LIST(9),
        TYPE_UUID(10),
        TYPE_DIMENSION_TYPE(11);

        private final int index;
        private static final Map<Integer, ArgumentType> mapping;

        private ArgumentType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ArgumentType getType(int index) {
            return mapping.get(index);
        }

        static {
            mapping = new HashMap<Integer, ArgumentType>();
            for (ArgumentType type : ArgumentType.values()) {
                mapping.put(type.index, type);
            }
        }
    }
}

