/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nonnull;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityTools {
    @Nonnull
    public static LazyOptional<IItemHandler> getItemCapabilitySafe(TileEntity tileEntity) {
        if (tileEntity == null) {
            return LazyOptional.empty();
        }
        try {
            return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        }
        catch (RuntimeException e) {
            CapabilityTools.reportWrongBlock(tileEntity, e);
            return LazyOptional.empty();
        }
    }

    @Nonnull
    public static LazyOptional<IFluidHandler> getFluidCapabilitySafe(TileEntity tileEntity) {
        if (tileEntity == null) {
            return LazyOptional.empty();
        }
        try {
            return tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        }
        catch (RuntimeException e) {
            CapabilityTools.reportWrongBlock(tileEntity, e);
            return LazyOptional.empty();
        }
    }

    private static void reportWrongBlock(TileEntity tileEntity, Exception e) {
        if (tileEntity != null) {
            ResourceLocation name = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v()).func_177230_c().getRegistryName();
            Logging.logError("Block " + name.toString() + " at " + BlockPosTools.toString(tileEntity.func_174877_v()) + " does not respect the capability API and crashes on null side.");
            Logging.logError("Please report to the corresponding mod. This is not a bug in RFTools!");
        }
        if (e != null) {
            Logging.logError("Exception", e);
        }
    }
}

