/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTools {
    @Nonnull
    public static ItemStack convertFluidToBucket(@Nonnull FluidStack fluidStack) {
        return FluidUtil.getFluidHandler((ItemStack)new ItemStack((IItemProvider)Items.field_151133_ar)).map(handler -> {
            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(ItemStack.field_190927_a);
    }

    @Nonnull
    public static FluidStack convertBucketToFluid(@Nonnull ItemStack bucket) {
        return FluidUtil.getFluidHandler((ItemStack)bucket).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (contents.isEmpty()) continue;
                return contents;
            }
            return FluidStack.EMPTY;
        }).orElse(FluidStack.EMPTY);
    }

    public static boolean isEmptyContainer(@Nonnull ItemStack itemStack) {
        return FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (handler.getTankCapacity(i) <= 0) continue;
                FluidStack contents = handler.getFluidInTank(i);
                if (contents.isEmpty()) {
                    return true;
                }
                if (contents.getAmount() <= 0) continue;
                return false;
            }
            return false;
        }).orElse(false);
    }

    public static boolean isFilledContainer(@Nonnull ItemStack itemStack) {
        return FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (!contents.isEmpty() && contents.getAmount() >= handler.getTankCapacity(i)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    @Nonnull
    public static ItemStack drainContainer(@Nonnull ItemStack container) {
        ItemStack empty = container.func_77946_l();
        empty.func_190920_e(1);
        return FluidUtil.getFluidHandler((ItemStack)empty).map(handler -> {
            if (!handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                return handler.getContainer();
            }
            return ItemStack.field_190927_a;
        }).orElse(ItemStack.field_190927_a);
    }

    @Nonnull
    public static ItemStack fillContainer(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        return FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l()).map(handler -> {
            int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            if (filled == 0) {
                return ItemStack.field_190927_a;
            }
            return handler.getContainer();
        }).orElse(ItemStack.field_190927_a);
    }

    @Nonnull
    public static FluidStack pickupFluidBlock(World world, BlockPos pos, @Nonnull Predicate<FluidStack> action, @Nonnull Runnable clearBlock) {
        BlockState blockstate = world.func_180495_p(pos);
        FluidState fluidstate = world.func_204610_c(pos);
        Material material = blockstate.func_185904_a();
        Fluid fluid = fluidstate.func_206886_c();
        if (blockstate.func_177230_c() instanceof IBucketPickupHandler && fluid != Fluids.field_204541_a) {
            FluidStack stack = new FluidStack(fluid, 1000);
            if (action.test(stack)) {
                return new FluidStack(((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)world, pos, blockstate), 1000);
            }
            return stack;
        }
        if (blockstate.func_177230_c() instanceof FlowingFluidBlock) {
            FluidStack stack = new FluidStack(fluid, 1000);
            if (action.test(stack)) {
                clearBlock.run();
            }
            return stack;
        }
        if (material == Material.field_203243_f || material == Material.field_204868_h) {
            FluidStack stack = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
            if (action.test(stack)) {
                TileEntity tileentity = blockstate.func_177230_c().hasTileEntity(blockstate) ? world.func_175625_s(pos) : null;
                Block.func_220059_a((BlockState)blockstate, (IWorld)world, (BlockPos)pos, (TileEntity)tileentity);
                clearBlock.run();
            }
            return stack;
        }
        return FluidStack.EMPTY;
    }
}

