/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.slottype;

import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.curios.api.type.ISlotType;

public final class SlotType
implements ISlotType {
    private final String identifier;
    private final int priority;
    private final int size;
    private final boolean locked;
    private final boolean visible;
    private final boolean cosmetic;
    private final ResourceLocation icon;

    private SlotType(Builder builder) {
        this.identifier = builder.identifier;
        this.priority = builder.priority != null ? builder.priority : 100;
        this.size = builder.size != null ? builder.size : 1;
        this.locked = builder.locked;
        this.visible = builder.visible;
        this.cosmetic = builder.cosmetic;
        this.icon = builder.icon != null ? builder.icon : new ResourceLocation("curios", "item/empty_curio_slot");
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean hasCosmetic() {
        return this.cosmetic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotType that = (SlotType)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    @Override
    public int compareTo(ISlotType otherType) {
        if (this.priority == otherType.getPriority()) {
            return this.identifier.compareTo(otherType.getIdentifier());
        }
        if (this.priority > otherType.getPriority()) {
            return 1;
        }
        return -1;
    }

    public static class Builder {
        private final String identifier;
        private Integer priority;
        private Integer size;
        private boolean locked = false;
        private boolean visible = true;
        private boolean cosmetic = false;
        private ResourceLocation icon = null;

        public Builder(String identifier) {
            this.identifier = identifier;
        }

        public Builder copyFrom(Builder builder) {
            this.priority = builder.priority;
            this.size = builder.size;
            this.locked = builder.locked;
            this.visible = builder.visible;
            this.cosmetic = builder.cosmetic;
            this.icon = builder.icon;
            return this;
        }

        public Builder icon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder priority(Integer priority) {
            return this.priority(priority, false);
        }

        public Builder priority(Integer priority, boolean force) {
            if (priority != null) {
                this.priority = this.priority != null ? Integer.valueOf(force ? priority : Math.min(this.priority, priority)) : priority;
            }
            return this;
        }

        public Builder size(int size) {
            return this.size(size, false);
        }

        public Builder size(int size, boolean force) {
            this.size = force || this.size == null ? size : Math.max(this.size, size);
            return this;
        }

        public Builder locked(boolean locked) {
            return this.locked(locked, false);
        }

        public Builder locked(boolean locked, boolean force) {
            this.locked = force ? locked : this.locked || locked;
            return this;
        }

        public Builder visible(boolean visible) {
            return this.visible(visible, false);
        }

        public Builder visible(boolean visible, boolean force) {
            this.visible = force ? visible : this.visible && visible;
            return this;
        }

        public Builder hasCosmetic(boolean cosmetic) {
            return this.hasCosmetic(cosmetic, false);
        }

        public Builder hasCosmetic(boolean cosmetic, boolean force) {
            this.cosmetic = force ? cosmetic : this.cosmetic || cosmetic;
            return this;
        }

        public SlotType build() {
            return new SlotType(this);
        }
    }
}

