/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettermodsbutton.client.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import fuzs.bettermodsbutton.BetterModsButton;
import fuzs.bettermodsbutton.compat.catalogue.CatalogueModListFactory;
import fuzs.bettermodsbutton.config.ClientConfig;
import fuzs.bettermodsbutton.lib.core.ModLoaderEnvironment;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ModScreenHandler {
    private NotificationModUpdateScreen gameMenuNotification;

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.getGui().getClass() == MainMenuScreen.class) {
            this.handleMainMenu(evt);
        } else if (evt.getGui() instanceof IngameMenuScreen) {
            this.handlePauseScreen(evt);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent evt) {
        if (evt.getGui() instanceof IngameMenuScreen) {
            this.gameMenuNotification.func_230430_a_(evt.getMatrixStack(), evt.getMouseX(), evt.getMouseY(), evt.getRenderPartialTicks());
        }
    }

    private void handleMainMenu(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (BetterModsButton.CONFIG.client().mainMenuMode == ClientConfig.MainMenuMode.NO_CHANGE) {
            return;
        }
        boolean modCount = BetterModsButton.CONFIG.client().modCount;
        this.getButton(evt.getWidgetList(), "fml.menu.mods").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
        Button modsButton = null;
        switch (BetterModsButton.CONFIG.client().mainMenuMode) {
            case INSERT_BELOW_REALMS: {
                for (Widget widget2 : evt.getWidgetList()) {
                    if (evt.getGui().field_230709_l_ / 4 + 48 + 72 + 12 <= widget2.field_230691_m_) {
                        widget2.field_230691_m_ += 12;
                        continue;
                    }
                    widget2.field_230691_m_ -= 12;
                }
                this.getButton(evt.getWidgetList(), "menu.online").ifPresent(widget -> {
                    widget.func_230991_b_(200);
                    widget.field_230690_l_ = evt.getGui().field_230708_k_ / 2 - 100;
                });
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 - 100, evt.getGui().field_230709_l_ / 4 + 48 + 72 - 12, 200, 20, this.getModsComponent(modCount, false), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case NONE: {
                this.getButton(evt.getWidgetList(), "menu.online").ifPresent(widget -> {
                    widget.func_230991_b_(200);
                    widget.field_230690_l_ = evt.getGui().field_230708_k_ / 2 - 100;
                });
                break;
            }
            case LEFT_TO_REALMS: {
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 - 100, evt.getGui().field_230709_l_ / 4 + 48 + 48, 98, 20, this.getModsComponent(modCount, true), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case RIGHT_TO_REALMS: {
                this.getButton(evt.getWidgetList(), "menu.online").ifPresent(widget -> {
                    widget.field_230690_l_ = evt.getGui().field_230708_k_ / 2 - 100;
                });
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 + 2, evt.getGui().field_230709_l_ / 4 + 48 + 48, 98, 20, this.getModsComponent(modCount, true), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case REPLACE_REALMS: {
                this.getButton(evt.getWidgetList(), "menu.online").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 - 100, evt.getGui().field_230709_l_ / 4 + 48 + 48, 200, 20, this.getModsComponent(modCount, false), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
            }
        }
        if (modsButton != null) {
            evt.addWidget(modsButton);
        }
        ObfuscationReflectionHelper.setPrivateValue(MainMenuScreen.class, (Object)((MainMenuScreen)evt.getGui()), (Object)NotificationModUpdateScreen.init((MainMenuScreen)((MainMenuScreen)evt.getGui()), BetterModsButton.CONFIG.client().updateNotification ? modsButton : null), (String)"modUpdateNotification");
    }

    private void handlePauseScreen(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (BetterModsButton.CONFIG.client().pauseScreenMode == ClientConfig.PauseScreenMode.NONE) {
            return;
        }
        boolean modCount = BetterModsButton.CONFIG.client().modCount;
        Button modsButton = null;
        switch (BetterModsButton.CONFIG.client().pauseScreenMode) {
            case INSERT_BELOW_FEEDBACK_AND_BUGS: {
                for (Widget widget2 : evt.getWidgetList()) {
                    if (evt.getGui().field_230709_l_ / 4 + 96 - 16 <= widget2.field_230691_m_) {
                        widget2.field_230691_m_ += 12;
                        continue;
                    }
                    widget2.field_230691_m_ -= 12;
                }
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 - 102, evt.getGui().field_230709_l_ / 4 + 96 - 16 - 12, 204, 20, this.getModsComponent(modCount, false), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case REPLACE_FEEDBACK: {
                this.getButton(evt.getWidgetList(), "menu.sendFeedback").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 - 102, evt.getGui().field_230709_l_ / 4 + 72 - 16, 98, 20, this.getModsComponent(modCount, true), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case REPLACE_BUGS: {
                this.getButton(evt.getWidgetList(), "menu.reportBugs").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 + 4, evt.getGui().field_230709_l_ / 4 + 72 - 16, 98, 20, this.getModsComponent(modCount, true), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case REPLACE_FEEDBACK_AND_BUGS: {
                this.getButton(evt.getWidgetList(), "menu.sendFeedback").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
                this.getButton(evt.getWidgetList(), "menu.reportBugs").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 - 102, evt.getGui().field_230709_l_ / 4 + 72 - 16, 204, 20, this.getModsComponent(modCount, false), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case REPLACE_AND_MOVE_LAN: {
                this.getButton(evt.getWidgetList(), "menu.sendFeedback").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
                this.getButton(evt.getWidgetList(), "menu.reportBugs").ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)evt).removeWidget(arg_0));
                this.getButton(evt.getWidgetList(), "menu.shareToLan").ifPresent(widget -> {
                    widget.func_230991_b_(204);
                    widget.field_230690_l_ = evt.getGui().field_230708_k_ / 2 - 102;
                    widget.field_230691_m_ = evt.getGui().field_230709_l_ / 4 + 72 - 16;
                });
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 + 4, evt.getGui().field_230709_l_ / 4 + 96 - 16, 98, 20, this.getModsComponent(modCount, true), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
                break;
            }
            case INSERT_AND_MOVE_LAN: {
                for (Widget widget3 : evt.getWidgetList()) {
                    if (evt.getGui().field_230709_l_ / 4 + 96 - 16 <= widget3.field_230691_m_) {
                        widget3.field_230691_m_ += 12;
                        continue;
                    }
                    widget3.field_230691_m_ -= 12;
                }
                this.getButton(evt.getWidgetList(), "menu.shareToLan").ifPresent(widget -> {
                    widget.func_230991_b_(204);
                    widget.field_230690_l_ = evt.getGui().field_230708_k_ / 2 - 102;
                    widget.field_230691_m_ = evt.getGui().field_230709_l_ / 4 + 96 - 16 - 12;
                });
                modsButton = new Button(evt.getGui().field_230708_k_ / 2 + 4, evt.getGui().field_230709_l_ / 4 + 96 - 16 + 12, 98, 20, this.getModsComponent(modCount, true), button -> evt.getGui().getMinecraft().func_147108_a(ModScreenHandler.createModListScreen(evt.getGui())));
            }
        }
        if (modsButton != null) {
            evt.addWidget(modsButton);
        }
        this.gameMenuNotification = new NotificationModUpdateScreen(BetterModsButton.CONFIG.client().updateNotification ? modsButton : null);
        this.gameMenuNotification.func_231152_a_(evt.getGui().getMinecraft(), evt.getGui().field_230708_k_, evt.getGui().field_230709_l_);
        this.gameMenuNotification.func_231160_c_();
    }

    private Optional<Widget> getButton(List<Widget> widgets, String s) {
        for (Widget widget : widgets) {
            if (!this.containsKey(widget, s)) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }

    private boolean containsKey(Widget button, String key) {
        ITextComponent message = button.func_230458_i_();
        return message instanceof TranslationTextComponent && ((TranslationTextComponent)message).func_150268_i().equals(key);
    }

    private ITextComponent getModsComponent(boolean withCount, boolean compact) {
        TranslationTextComponent component = new TranslationTextComponent("fml.menu.mods");
        if (withCount) {
            String translationKey = compact ? "button.mods.count.compact" : "button.mods.count";
            component = component.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(translationKey, new Object[]{ModList.get().size()}));
        }
        return component;
    }

    private static Screen createModListScreen(Screen lastScreen) {
        if (!BetterModsButton.CONFIG.client().forceDirtBackground) {
            return new ModListScreen(lastScreen);
        }
        if (ModLoaderEnvironment.isModLoaded("catalogue")) {
            try {
                return CatalogueModListFactory.createCatalogueModListScreen();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new ModListScreen(lastScreen){

            public void func_238651_a_(MatrixStack pMatrixStack, int pVOffset) {
                this.func_231165_f_(pVOffset);
            }
        };
    }
}

