/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettermodsbutton.lib.config;

import com.google.common.collect.Lists;
import fuzs.bettermodsbutton.BetterModsButton;
import fuzs.bettermodsbutton.lib.config.AbstractConfig;
import fuzs.bettermodsbutton.lib.config.ConfigHolder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ConfigHolderImpl<C extends AbstractConfig, S extends AbstractConfig>
implements ConfigHolder<C, S> {
    @Nullable
    private final C client;
    @Nullable
    private final S server;
    private final List<Runnable> clientCallbacks = Lists.newArrayList();
    private final List<Runnable> serverCallbacks = Lists.newArrayList();
    private String clientFileName = "";
    private String serverFileName = "";

    ConfigHolderImpl(@Nonnull Supplier<C> client, @Nonnull Supplier<S> server) {
        this.client = FMLEnvironment.dist.isClient() ? (AbstractConfig)client.get() : null;
        this.server = (AbstractConfig)server.get();
    }

    @SubscribeEvent
    public void onModConfig(ModConfig.ModConfigEvent evt, String modId) {
        if (evt.getConfig().getModId().equals(modId)) {
            ModConfig.Type type = evt.getConfig().getType();
            switch (type) {
                case CLIENT: {
                    this.clientCallbacks.forEach(Runnable::run);
                    break;
                }
                case SERVER: {
                    this.serverCallbacks.forEach(Runnable::run);
                    break;
                }
                case COMMON: {
                    throw new RuntimeException("Common config type not supported");
                }
            }
            if (evt instanceof ModConfig.Reloading) {
                BetterModsButton.LOGGER.info("Reloading {} config for {}", (Object)type.extension(), (Object)modId);
            }
        }
    }

    private <T> void addSaveCallback(ModConfig.Type type, ForgeConfigSpec.ConfigValue<T> entry, Consumer<T> save) {
        switch (type) {
            case CLIENT: {
                this.clientCallbacks.add(() -> save.accept(entry.get()));
                break;
            }
            case SERVER: {
                this.serverCallbacks.add(() -> save.accept(entry.get()));
                break;
            }
            case COMMON: {
                throw new RuntimeException("Common config type not supported");
            }
        }
    }

    public void addConfigs(String modId) {
        this.addConfigs(ModLoadingContext.get());
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(evt -> this.onModConfig((ModConfig.ModConfigEvent)evt, modId));
    }

    private void addConfigs(ModLoadingContext context) {
        ConfigHolder.ConfigCallback saveCallback;
        if (this.client != null) {
            saveCallback = new ConfigHolder.ConfigCallback(){

                @Override
                public <T> void accept(ForgeConfigSpec.ConfigValue<T> entry, Consumer<T> save) {
                    ConfigHolderImpl.this.addSaveCallback(ModConfig.Type.CLIENT, entry, save);
                }
            };
            if (this.clientFileName.isEmpty()) {
                context.registerConfig(ModConfig.Type.CLIENT, this.buildSpec((AbstractConfig)this.client, saveCallback));
            } else {
                context.registerConfig(ModConfig.Type.CLIENT, this.buildSpec((AbstractConfig)this.client, saveCallback), this.clientFileName);
            }
            this.addClientCallback(() -> this.client.afterConfigReload());
        }
        if (this.server != null) {
            saveCallback = new ConfigHolder.ConfigCallback(){

                @Override
                public <T> void accept(ForgeConfigSpec.ConfigValue<T> entry, Consumer<T> save) {
                    ConfigHolderImpl.this.addSaveCallback(ModConfig.Type.SERVER, entry, save);
                }
            };
            if (this.serverFileName.isEmpty()) {
                context.registerConfig(ModConfig.Type.SERVER, this.buildSpec((AbstractConfig)this.server, saveCallback));
            } else {
                context.registerConfig(ModConfig.Type.SERVER, this.buildSpec((AbstractConfig)this.server, saveCallback), this.serverFileName);
            }
            this.addServerCallback(() -> this.server.afterConfigReload());
        }
    }

    private ForgeConfigSpec buildSpec(AbstractConfig config, ConfigHolder.ConfigCallback saveCallback) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        config.setupConfig(builder, saveCallback);
        return builder.build();
    }

    public ConfigHolderImpl<C, S> setClientFileName(String fileName) {
        this.clientFileName = fileName;
        return this;
    }

    public ConfigHolderImpl<C, S> setServerFileName(String fileName) {
        this.serverFileName = fileName;
        return this;
    }

    @Override
    public C client() {
        return this.client;
    }

    @Override
    public S server() {
        return this.server;
    }

    @Override
    public void addClientCallback(Runnable callback) {
        this.clientCallbacks.add(callback);
    }

    @Override
    public void addServerCallback(Runnable callback) {
        this.serverCallbacks.add(callback);
    }
}

