/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.smooth;

import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.smooth.AoNeighborInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

class AoFaceData {
    public final int[] lm = new int[4];
    public final float[] ao = new float[4];
    public final float[] bl = new float[4];
    public final float[] sl = new float[4];
    private int flags;

    AoFaceData() {
    }

    public void initLightData(LightDataAccess cache, BlockPos pos, Direction direction, boolean offset) {
        float c3ao;
        int c3lm;
        float c2ao;
        int c2lm;
        float c1ao;
        int c1lm;
        float c0ao;
        int c0lm;
        int adjZ;
        int adjY;
        int adjX;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (offset) {
            adjX = x + direction.func_82601_c();
            adjY = y + direction.func_96559_d();
            adjZ = z + direction.func_82599_e();
        } else {
            adjX = x;
            adjY = y;
            adjZ = z;
        }
        long adjWord = cache.get(adjX, adjY, adjZ);
        int calm = offset && LightDataAccess.unpackFO(adjWord) ? LightDataAccess.unpackLM(cache.get(x, y, z)) : LightDataAccess.unpackLM(adjWord);
        float caao = LightDataAccess.unpackAO(adjWord);
        Direction[] faces = AoNeighborInfo.get((Direction)direction).faces;
        long e0 = cache.get(adjX, adjY, adjZ, faces[0]);
        int e0lm = LightDataAccess.unpackLM(e0);
        float e0ao = LightDataAccess.unpackAO(e0);
        boolean e0op = LightDataAccess.unpackOP(e0);
        long e1 = cache.get(adjX, adjY, adjZ, faces[1]);
        int e1lm = LightDataAccess.unpackLM(e1);
        float e1ao = LightDataAccess.unpackAO(e1);
        boolean e1op = LightDataAccess.unpackOP(e1);
        long e2 = cache.get(adjX, adjY, adjZ, faces[2]);
        int e2lm = LightDataAccess.unpackLM(e2);
        float e2ao = LightDataAccess.unpackAO(e2);
        boolean e2op = LightDataAccess.unpackOP(e2);
        long e3 = cache.get(adjX, adjY, adjZ, faces[3]);
        int e3lm = LightDataAccess.unpackLM(e3);
        float e3ao = LightDataAccess.unpackAO(e3);
        boolean e3op = LightDataAccess.unpackOP(e3);
        if (!e2op && !e0op) {
            c0lm = e0lm;
            c0ao = e0ao;
        } else {
            long d0 = cache.get(adjX, adjY, adjZ, faces[0], faces[2]);
            c0lm = LightDataAccess.unpackLM(d0);
            c0ao = LightDataAccess.unpackAO(d0);
        }
        if (!e3op && !e0op) {
            c1lm = e0lm;
            c1ao = e0ao;
        } else {
            long d1 = cache.get(adjX, adjY, adjZ, faces[0], faces[3]);
            c1lm = LightDataAccess.unpackLM(d1);
            c1ao = LightDataAccess.unpackAO(d1);
        }
        if (!e2op && !e1op) {
            c2lm = e1lm;
            c2ao = e1ao;
        } else {
            long d2 = cache.get(adjX, adjY, adjZ, faces[1], faces[2]);
            c2lm = LightDataAccess.unpackLM(d2);
            c2ao = LightDataAccess.unpackAO(d2);
        }
        if (!e3op && !e1op) {
            c3lm = e1lm;
            c3ao = e1ao;
        } else {
            long d3 = cache.get(adjX, adjY, adjZ, faces[1], faces[3]);
            c3lm = LightDataAccess.unpackLM(d3);
            c3ao = LightDataAccess.unpackAO(d3);
        }
        float[] ao = this.ao;
        ao[0] = (e3ao + e0ao + c1ao + caao) * 0.25f;
        ao[1] = (e2ao + e0ao + c0ao + caao) * 0.25f;
        ao[2] = (e2ao + e1ao + c2ao + caao) * 0.25f;
        ao[3] = (e3ao + e1ao + c3ao + caao) * 0.25f;
        int[] cb = this.lm;
        cb[0] = AoFaceData.calculateCornerBrightness(e3lm, e0lm, c1lm, calm);
        cb[1] = AoFaceData.calculateCornerBrightness(e2lm, e0lm, c0lm, calm);
        cb[2] = AoFaceData.calculateCornerBrightness(e2lm, e1lm, c2lm, calm);
        cb[3] = AoFaceData.calculateCornerBrightness(e3lm, e1lm, c3lm, calm);
        this.flags |= 1;
    }

    public void unpackLightData() {
        int[] lm = this.lm;
        float[] bl = this.bl;
        float[] sl = this.sl;
        bl[0] = AoFaceData.unpackBlockLight(lm[0]);
        bl[1] = AoFaceData.unpackBlockLight(lm[1]);
        bl[2] = AoFaceData.unpackBlockLight(lm[2]);
        bl[3] = AoFaceData.unpackBlockLight(lm[3]);
        sl[0] = AoFaceData.unpackSkyLight(lm[0]);
        sl[1] = AoFaceData.unpackSkyLight(lm[1]);
        sl[2] = AoFaceData.unpackSkyLight(lm[2]);
        sl[3] = AoFaceData.unpackSkyLight(lm[3]);
        this.flags |= 2;
    }

    public float getBlendedSkyLight(float[] w) {
        return AoFaceData.weightedSum(this.sl, w);
    }

    public float getBlendedBlockLight(float[] w) {
        return AoFaceData.weightedSum(this.bl, w);
    }

    public float getBlendedShade(float[] w) {
        return AoFaceData.weightedSum(this.ao, w);
    }

    private static float weightedSum(float[] v, float[] w) {
        float t0 = v[0] * w[0];
        float t1 = v[1] * w[1];
        float t2 = v[2] * w[2];
        float t3 = v[3] * w[3];
        return t0 + t1 + t2 + t3;
    }

    private static float unpackSkyLight(int i) {
        return i >> 16 & 0xFF;
    }

    private static float unpackBlockLight(int i) {
        return i & 0xFF;
    }

    private static int calculateCornerBrightness(int a, int b, int c, int d) {
        if (a == 0 || b == 0 || c == 0 || d == 0) {
            int min = AoFaceData.minNonZero(AoFaceData.minNonZero(a, b), AoFaceData.minNonZero(c, d));
            a = Math.max(a, min);
            b = Math.max(b, min);
            c = Math.max(c, min);
            d = Math.max(d, min);
        }
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int minNonZero(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    public boolean hasLightData() {
        return (this.flags & 1) != 0;
    }

    public boolean hasUnpackedLightData() {
        return (this.flags & 2) != 0;
    }

    public void reset() {
        this.flags = 0;
    }
}

