/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderEmptyBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderRebuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.common.util.collections.DequeDrain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkBuilder<T extends ChunkGraphicsState> {
    private static final int TASK_QUEUE_LIMIT_PER_WORKER = 2;
    private static final Logger LOGGER = LogManager.getLogger((String)"ChunkBuilder");
    private final Deque<WrappedTask<T>> buildQueue = new ConcurrentLinkedDeque<WrappedTask<T>>();
    private final Deque<ChunkBuildResult<T>> uploadQueue = new ConcurrentLinkedDeque<ChunkBuildResult<T>>();
    private final Object jobNotifier = new Object();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<Thread> threads = new ArrayList<Thread>();
    private ClonedChunkSectionCache sectionCache;
    private World world;
    private BlockRenderPassManager renderPassManager;
    private final int limitThreads;
    private final ChunkVertexType vertexType;
    private final ChunkRenderBackend<T> backend;

    public ChunkBuilder(ChunkVertexType vertexType, ChunkRenderBackend<T> backend) {
        this.vertexType = vertexType;
        this.backend = backend;
        this.limitThreads = ChunkBuilder.getOptimalThreadCount();
    }

    public int getSchedulingBudget() {
        return Math.max(0, this.limitThreads * 2 - this.buildQueue.size());
    }

    public void startWorkers() {
        if (this.running.getAndSet(true)) {
            return;
        }
        if (!this.threads.isEmpty()) {
            throw new IllegalStateException("Threads are still alive while in the STOPPED state");
        }
        Minecraft client = Minecraft.func_71410_x();
        for (int i = 0; i < this.limitThreads; ++i) {
            ChunkBuildBuffers buffers = new ChunkBuildBuffers(this.vertexType, this.renderPassManager);
            ChunkRenderCacheLocal pipeline = new ChunkRenderCacheLocal(client, this.world);
            WorkerRunnable worker = new WorkerRunnable(buffers, pipeline);
            Thread thread = new Thread((Runnable)worker, "Chunk Render Task Executor #" + i);
            thread.setPriority(Math.max(0, 3));
            thread.start();
            this.threads.add(thread);
        }
        LOGGER.info("Started {} worker threads", (Object)this.threads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorkers() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        if (this.threads.isEmpty()) {
            throw new IllegalStateException("No threads are alive but the executor is in the RUNNING state");
        }
        LOGGER.info("Stopping worker threads");
        Iterator<Object> iterator = this.jobNotifier;
        synchronized (iterator) {
            this.jobNotifier.notifyAll();
        }
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threads.clear();
        this.uploadQueue.clear();
        for (WrappedTask wrappedTask : this.buildQueue) {
            wrappedTask.future.cancel(true);
        }
        this.buildQueue.clear();
        this.world = null;
        this.sectionCache = null;
    }

    public boolean performPendingUploads() {
        if (this.uploadQueue.isEmpty()) {
            return false;
        }
        this.backend.upload(RenderDevice.INSTANCE.createCommandList(), new DequeDrain<ChunkBuildResult<T>>(this.uploadQueue));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ChunkBuildResult<T>> schedule(ChunkRenderBuildTask<T> task) {
        if (!this.running.get()) {
            throw new IllegalStateException("Executor is stopped");
        }
        WrappedTask job = new WrappedTask(task);
        this.buildQueue.add(job);
        Object object = this.jobNotifier;
        synchronized (object) {
            this.jobNotifier.notify();
        }
        return job.future;
    }

    public boolean isBuildQueueEmpty() {
        return this.buildQueue.isEmpty();
    }

    public void init(ClientWorld world, BlockRenderPassManager renderPassManager) {
        if (world == null) {
            throw new NullPointerException("World is null");
        }
        this.stopWorkers();
        this.world = world;
        this.renderPassManager = renderPassManager;
        this.sectionCache = new ClonedChunkSectionCache(this.world);
        this.startWorkers();
    }

    private static int getOptimalThreadCount() {
        return Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    public void deferRebuild(ChunkRenderContainer<T> render) {
        this.scheduleRebuildTaskAsync(render).thenAccept(this::enqueueUpload);
    }

    private void enqueueUpload(ChunkBuildResult<T> result) {
        this.uploadQueue.add(result);
    }

    public CompletableFuture<ChunkBuildResult<T>> scheduleRebuildTaskAsync(ChunkRenderContainer<T> render) {
        return this.schedule(this.createRebuildTask(render));
    }

    private ChunkRenderBuildTask<T> createRebuildTask(ChunkRenderContainer<T> render) {
        render.cancelRebuildTask();
        ChunkRenderContext context = WorldSlice.prepare(this.world, render.getChunkPos(), this.sectionCache);
        if (context == null) {
            return new ChunkRenderEmptyBuildTask<T>(render);
        }
        return new ChunkRenderRebuildTask<T>(render, context, render.getRenderOrigin());
    }

    public void onChunkDataChanged(int x, int y, int z) {
        this.sectionCache.invalidate(x, y, z);
    }

    private static class WrappedTask<T extends ChunkGraphicsState>
    implements CancellationSource {
        private final ChunkRenderBuildTask<T> task;
        private final CompletableFuture<ChunkBuildResult<T>> future;

        private WrappedTask(ChunkRenderBuildTask<T> task) {
            this.task = task;
            this.future = new CompletableFuture();
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private final AtomicBoolean running;
        private final ChunkBuildBuffers bufferCache;
        private final ChunkRenderCacheLocal cache;

        public WorkerRunnable(ChunkBuildBuffers bufferCache, ChunkRenderCacheLocal cache) {
            this.running = ChunkBuilder.this.running;
            this.bufferCache = bufferCache;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running.get()) {
                ChunkBuildResult result;
                WrappedTask job = this.getNextJob();
                if (job == null || job.isCancelled()) continue;
                try {
                    result = job.task.performBuild(this.cache, this.bufferCache, job);
                }
                catch (Exception e) {
                    job.future.completeExceptionally(e);
                    continue;
                }
                finally {
                    job.task.releaseResources();
                    continue;
                }
                if (result != null) {
                    job.future.complete(result);
                    continue;
                }
                if (job.isCancelled()) continue;
                job.future.completeExceptionally(new RuntimeException("No result was produced by the task"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WrappedTask<T> getNextJob() {
            WrappedTask job = (WrappedTask)ChunkBuilder.this.buildQueue.poll();
            if (job == null) {
                Object object = ChunkBuilder.this.jobNotifier;
                synchronized (object) {
                    try {
                        ChunkBuilder.this.jobNotifier.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return job;
        }
    }
}

