/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.level.ColorResolver;

public class BiomeColorCache {
    private static final int BLENDED_COLORS_DIM = 20;
    private final ColorResolver resolver;
    private final WorldSlice slice;
    private final int[] blendedColors;
    private final int[] cache;
    private final int radius;
    private final int dim;
    private final int minX;
    private final int minZ;
    private final int height;
    private final int blendedColorsMinX;
    private final int blendedColorsMinZ;

    public BiomeColorCache(ColorResolver resolver, WorldSlice slice) {
        this.resolver = resolver;
        this.slice = slice;
        this.radius = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        SectionPos origin = this.slice.getOrigin();
        this.minX = origin.func_218161_d() - (this.radius + 2);
        this.minZ = origin.func_218164_f() - (this.radius + 2);
        this.height = origin.func_218151_e();
        this.dim = 16 + (this.radius + 2) * 2;
        this.blendedColorsMinX = origin.func_218161_d() - 2;
        this.blendedColorsMinZ = origin.func_218164_f() - 2;
        this.cache = new int[this.dim * this.dim];
        this.blendedColors = new int[400];
        Arrays.fill(this.cache, -1);
        Arrays.fill(this.blendedColors, -1);
    }

    public int getBlendedColor(BlockPos pos) {
        int z2;
        int x2 = pos.func_177958_n() - this.blendedColorsMinX;
        int index = x2 * 20 + (z2 = pos.func_177952_p() - this.blendedColorsMinZ);
        int color = this.blendedColors[index];
        if (color == -1) {
            this.blendedColors[index] = color = this.calculateBlendedColor(pos.func_177958_n(), pos.func_177952_p());
        }
        return color;
    }

    private int calculateBlendedColor(int posX, int posZ) {
        if (this.radius == 0) {
            return this.getColor(posX, posZ);
        }
        int diameter = this.radius * 2 + 1;
        int area = diameter * diameter;
        int r = 0;
        int g = 0;
        int b = 0;
        int minX = posX - this.radius;
        int minZ = posZ - this.radius;
        int maxX = posX + this.radius;
        int maxZ = posZ + this.radius;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                int color = this.getColor(x2, z2);
                r += ColorARGB.unpackRed(color);
                g += ColorARGB.unpackGreen(color);
                b += ColorARGB.unpackBlue(color);
            }
        }
        return ColorARGB.pack(r / area, g / area, b / area, 255);
    }

    private int getColor(int x, int z) {
        int index = (x - this.minX) * this.dim + (z - this.minZ);
        int color = this.cache[index];
        if (color == -1) {
            this.cache[index] = color = this.calculateColor(x, z);
        }
        return color;
    }

    private int calculateColor(int x, int z) {
        return this.resolver.getColor(this.slice.getBiome(x, this.height, z), (double)x, (double)z);
    }
}

