/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.particle.cull;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.util.math.AxisAlignedBB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleManager.class})
public class MixinParticleManager {
    @Shadow
    @Final
    private Map<IParticleRenderType, Queue<Particle>> field_78876_b;
    private final Queue<Particle> cachedQueue = new ArrayDeque<Particle>();
    private ClippingHelper cullingFrustum;

    @Inject(method={"renderParticles(Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer$Impl;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/renderer/ActiveRenderInfo;FLnet/minecraft/client/renderer/culling/ClippingHelper;)V"}, at={@At(value="HEAD")}, remap=false)
    private void preRenderParticles(MatrixStack matrixStack, IRenderTypeBuffer.Impl immediate, LightTexture lightmapTextureManager, ActiveRenderInfo camera, float f, ClippingHelper clippingHelper, CallbackInfo ci) {
        ClippingHelper frustum = SodiumWorldRenderer.getInstance().getFrustum();
        boolean useCulling = SodiumClientMod.options().advanced.useParticleCulling;
        this.cullingFrustum = useCulling && frustum != null ? frustum : null;
    }

    @Redirect(method={"renderParticles(Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer$Impl;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/renderer/ActiveRenderInfo;FLnet/minecraft/client/renderer/culling/ClippingHelper;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;"), remap=false)
    private <V> V filterParticleList(Map<IParticleRenderType, Queue<Particle>> map, Object key, MatrixStack matrixStack, IRenderTypeBuffer.Impl immediate, LightTexture lightmapTextureManager, ActiveRenderInfo camera, float f, ClippingHelper clippingHelper) {
        Queue<Particle> queue = this.field_78876_b.get(key);
        if (queue == null || queue.isEmpty()) {
            return null;
        }
        if (this.cullingFrustum == null) {
            return (V)queue;
        }
        Queue<Particle> filtered = this.cachedQueue;
        filtered.clear();
        for (Particle particle : queue) {
            AxisAlignedBB box = particle.func_187116_l();
            if (!this.cullingFrustum.func_228953_a_(box.field_72340_a - 1.0, box.field_72338_b - 1.0, box.field_72339_c - 1.0, box.field_72336_d + 1.0, box.field_72337_e + 1.0, box.field_72334_f + 1.0)) continue;
            filtered.add(particle);
        }
        return (V)filtered;
    }

    @Inject(method={"renderParticles"}, at={@At(value="RETURN")})
    private void postRenderParticles(MatrixStack matrixStack, IRenderTypeBuffer.Impl immediate, LightTexture lightmapTextureManager, ActiveRenderInfo camera, float f, CallbackInfo ci) {
        this.cachedQueue.clear();
    }
}

