/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import team.chisel.ctm.client.util.Dir;

@ParametersAreNonnullByDefault
public enum ConnectionLocations {
    UP(Dir.TOP),
    DOWN(Dir.BOTTOM),
    NORTH(Direction.EAST, Dir.RIGHT),
    SOUTH(Direction.EAST, Dir.LEFT),
    EAST(Dir.RIGHT),
    WEST(Dir.LEFT),
    NORTH_EAST(Direction.UP, Dir.TOP_RIGHT),
    NORTH_WEST(Direction.UP, Dir.TOP_LEFT),
    SOUTH_EAST(Direction.UP, Dir.BOTTOM_RIGHT),
    SOUTH_WEST(Direction.UP, Dir.BOTTOM_LEFT),
    NORTH_UP(Direction.EAST, Dir.TOP_RIGHT),
    NORTH_DOWN(Direction.EAST, Dir.BOTTOM_RIGHT),
    SOUTH_UP(Direction.EAST, Dir.TOP_LEFT),
    SOUTH_DOWN(Direction.EAST, Dir.BOTTOM_LEFT),
    EAST_UP(Dir.TOP_RIGHT),
    EAST_DOWN(Dir.BOTTOM_RIGHT),
    WEST_UP(Dir.TOP_LEFT),
    WEST_DOWN(Dir.BOTTOM_LEFT),
    NORTH_EAST_UP(Direction.EAST, Dir.TOP_RIGHT, true),
    NORTH_EAST_DOWN(Direction.EAST, Dir.BOTTOM_RIGHT, true),
    SOUTH_EAST_UP(Direction.EAST, Dir.TOP_LEFT, true),
    SOUTH_EAST_DOWN(Direction.EAST, Dir.BOTTOM_LEFT, true),
    SOUTH_WEST_UP(Direction.WEST, Dir.TOP_LEFT, true),
    SOUTH_WEST_DOWN(Direction.WEST, Dir.BOTTOM_LEFT, true),
    NORTH_WEST_UP(Direction.WEST, Dir.TOP_RIGHT, true),
    NORTH_WEST_DOWN(Direction.WEST, Dir.BOTTOM_RIGHT, true),
    UP_UP(Direction.UP, null, true),
    DOWN_DOWN(Direction.DOWN, null, true),
    NORTH_NORTH(Direction.NORTH, null, true),
    SOUTH_SOUTH(Direction.SOUTH, null, true),
    EAST_EAST(Direction.EAST, null, true),
    WEST_WEST(Direction.WEST, null, true);

    public static final ConnectionLocations[] VALUES;
    private final Direction normal;
    @Nullable
    private final Dir dir;
    private boolean offset;

    private ConnectionLocations(Dir dir) {
        this(Direction.SOUTH, dir);
    }

    private ConnectionLocations(Dir dir, boolean offset) {
        this(Direction.SOUTH, dir, offset);
    }

    private ConnectionLocations(Direction normal, Dir dir) {
        this(normal, dir, false);
    }

    private ConnectionLocations(Direction normal, Dir dir, boolean offset) {
        this.normal = normal;
        this.dir = dir;
        this.offset = offset;
    }

    @Nullable
    public Dir getDirForSide(Direction facing) {
        return this.dir == null ? null : this.dir.relativize(facing);
    }

    @Nullable
    public Direction clipOrDestroy(Direction direction) {
        throw new UnsupportedOperationException();
    }

    public BlockPos transform(BlockPos pos) {
        pos = this.dir != null ? pos.func_177971_a((Vector3i)this.dir.getOffset(this.normal)) : pos.func_177972_a(this.normal);
        if (this.offset) {
            pos = pos.func_177972_a(this.normal);
        }
        return pos;
    }

    public static ConnectionLocations fromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return NORTH;
    }

    public static Direction toFacing(ConnectionLocations loc) {
        switch (loc) {
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.WEST;
            }
            case UP: {
                return Direction.UP;
            }
            case DOWN: {
                return Direction.DOWN;
            }
        }
        return Direction.NORTH;
    }

    public static List<ConnectionLocations> decode(long data) {
        ArrayList<ConnectionLocations> list = new ArrayList<ConnectionLocations>();
        for (ConnectionLocations loc : ConnectionLocations.values()) {
            if ((1L & data >> loc.ordinal()) == 0L) continue;
            list.add(loc);
        }
        return list;
    }

    public long getMask() {
        return 1 << this.ordinal();
    }

    static {
        VALUES = ConnectionLocations.values();
    }
}

