/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.IngredientVanillaPlus;
import com.blamejared.crafttweaker.impl.item.MCIngredientList;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.expansions.ExpandItemTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerItem;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CompoundIngredient;

public class IngredientConverter {
    public static IIngredient fromIngredient(Ingredient ingredient) {
        if (ingredient instanceof IngredientVanillaPlus) {
            return ((IngredientVanillaPlus)ingredient).getCrTIngredient();
        }
        if (ingredient == Ingredient.field_193370_a) {
            return IngredientConverter.empty();
        }
        if (ingredient instanceof CompoundIngredient) {
            return IngredientConverter.mergeIngredients((IIngredient[])((CompoundIngredient)ingredient).getChildren().stream().map(IngredientConverter::fromIngredient).toArray(IIngredient[]::new));
        }
        return IngredientConverter.fromIItemLists(ingredient.field_199807_b);
    }

    private static IIngredient fromIItemLists(Ingredient.IItemList ... itemLists) {
        IIngredient[] ingredients = (IIngredient[])Arrays.stream(itemLists).map(IngredientConverter::fromIItemList).filter(IngredientConverter::notEmptyStack).toArray(IIngredient[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromIItemList(Ingredient.IItemList itemList) {
        if (itemList instanceof Ingredient.TagList) {
            return IngredientConverter.fromTagList((Ingredient.TagList)itemList);
        }
        IIngredient[] ingredients = (IItemStack[])itemList.func_199799_a().stream().filter(stack -> !stack.func_190926_b()).map(MCItemStack::new).toArray(IItemStack[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromTagList(Ingredient.TagList tagList) {
        ResourceLocation location = TagManagerItem.INSTANCE.getTagCollection().func_232973_a_(tagList.field_199800_a);
        MCTag<Item> itemMCTag = new MCTag<Item>(location, TagManagerItem.INSTANCE);
        return ExpandItemTag.asIIngredient(itemMCTag);
    }

    private static IIngredient empty() {
        return MCItemStack.EMPTY.get();
    }

    private static IIngredient mergeIngredients(IIngredient ... ingredients) {
        if (ingredients.length == 0) {
            return IngredientConverter.empty();
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new MCIngredientList(ingredients);
    }

    private static boolean notEmptyStack(IIngredient iIngredient) {
        return !(iIngredient instanceof IItemStack) || !((IItemStack)iIngredient).isEmpty();
    }
}

