/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.mods;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.mods.ModInfo")
@Document(value="vanilla/api/mods/ModInfo")
public class MCModInfo {
    private final ModInfo modInfo;

    public MCModInfo(ModInfo modInfo) {
        this.modInfo = modInfo;
    }

    @ZenCodeType.Getter(value="modid")
    public String getModId() {
        return this.getModInfo().getModId();
    }

    @ZenCodeType.Getter(value="displayName")
    public String getDisplayName() {
        return this.getModInfo().getDisplayName();
    }

    @ZenCodeType.Getter(value="version")
    public String getVersion() {
        return this.getModInfo().getVersion().toString();
    }

    @ZenCodeType.Getter(value="items")
    public List<IItemStack> getItems() {
        return ForgeRegistries.ITEMS.getEntries().stream().filter(resourceLocationItemEntry -> ((RegistryKey)resourceLocationItemEntry.getKey()).func_240901_a_().func_110624_b().equals(this.getModId())).map(Map.Entry::getValue).map(ItemStack::new).map(MCItemStack::new).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="blocks")
    public List<Block> getBlocks() {
        return ForgeRegistries.BLOCKS.getEntries().stream().filter(resourceLocationItemEntry -> ((RegistryKey)resourceLocationItemEntry.getKey()).func_240901_a_().func_110624_b().equals(this.getModId())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="entitytypes")
    public List<MCEntityType> getEntityTypes() {
        return ForgeRegistries.ENTITIES.getEntries().stream().filter(resourceLocationItemEntry -> ((RegistryKey)resourceLocationItemEntry.getKey()).func_240901_a_().func_110624_b().equals(this.getModId())).map(Map.Entry::getValue).map(MCEntityType::new).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="fluids")
    public List<Fluid> getFluids() {
        return ForgeRegistries.FLUIDS.getEntries().stream().filter(registryKeyFluidEntry -> ((RegistryKey)registryKeyFluidEntry.getKey()).func_240901_a_().func_110624_b().equals(this.getModId())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="namespace")
    public String getNamespace() {
        return this.getModInfo().getModId();
    }

    public ModInfo getModInfo() {
        return this.modInfo;
    }
}

