/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class RecipePrintingUtil {
    public static String stringifyIngredients(List<Ingredient> ingredients, String delimeter) {
        return ingredients.stream().map(IIngredient::fromIngredient).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }

    public static String stringifyStacks(List<ItemStack> ingredients, String delimeter) {
        return ingredients.stream().map(MCItemStackMutable::new).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }

    public static String stringifyWeightedStacks(List<ItemStack> ingredients, List<Float> weights, String delimeter) {
        Iterator<Float> iterator = weights.iterator();
        return ingredients.stream().filter(val -> iterator.hasNext()).map(itemStack -> new MCWeightedItemStack(new MCItemStackMutable((ItemStack)itemStack), ((Float)iterator.next()).floatValue())).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }

    public static String stringifyFluidStacks(List<FluidStack> ingredients, String delimeter) {
        return ingredients.stream().map(MCFluidStackMutable::new).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }
}

