/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets.tags;

import com.blamejared.crafttweaker.impl.brackets.tags.TagManagerBracketHandler;
import com.blamejared.crafttweaker.impl.brackets.util.ParseUtil;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.expression.ParsedExpressionString;
import org.openzen.zenscript.parser.expression.ParsedNewExpression;

public class TagBracketHandler
implements BracketExpressionParser {
    private final TagManagerBracketHandler tagManagerBracketHandler;

    public TagBracketHandler(TagManagerBracketHandler tagManagerBracketHandler) {
        this.tagManagerBracketHandler = tagManagerBracketHandler;
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        if (tokens.optional(ZSTokenType.T_GREATER) != null) {
            throw new ParseException(position, "Invalid Bracket handler, expected tagFolder here");
        }
        String tagFolder = ((ZSToken)tokens.next()).getContent();
        this.tagManagerBracketHandler.confirmTagFolderExists(tagFolder, position);
        tokens.required(ZSTokenType.T_COLON, "Expected ':', followed by Tag Name");
        String tagName = ParseUtil.readContent(tokens);
        ResourceLocation resourceLocation = ResourceLocation.func_208304_a((String)tagName);
        if (resourceLocation == null) {
            throw new ParseException(position, "Invalid Tag Name '" + tagName + "', must be a valid resource location");
        }
        return this.createCall(position, tagFolder, resourceLocation);
    }

    private ParsedExpression createCall(CodePosition position, String tagFolder, ResourceLocation location) throws ParseException {
        ParsedExpression tagManager = this.tagManagerBracketHandler.getParsedExpression(position, tagFolder);
        ParsedExpressionMember getTag = new ParsedExpressionMember(position, tagManager, "getTag", null);
        ParsedNewExpression newExpression = this.createResourceLocationArgument(position, location);
        ParsedCallArguments arguments = new ParsedCallArguments(null, Collections.singletonList(newExpression));
        return new ParsedExpressionCall(position, getTag, arguments);
    }

    private ParsedNewExpression createResourceLocationArgument(CodePosition position, ResourceLocation location) {
        ArrayList<ParsedExpression> arguments = new ArrayList<ParsedExpression>(2);
        arguments.add(new ParsedExpressionString(position, location.func_110624_b(), false));
        arguments.add(new ParsedExpressionString(position, location.func_110623_a(), false));
        ParsedCallArguments newCallArguments = new ParsedCallArguments(null, arguments);
        return new ParsedNewExpression(position, ParseUtil.readParsedType("crafttweaker.api.util.MCResourceLocation", position), newCallArguments);
    }
}

