/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands;

import com.blamejared.crafttweaker.impl.commands.CommandCaller;
import java.util.Map;
import java.util.TreeMap;

public class CommandImpl
implements Comparable<CommandImpl> {
    private final String name;
    private final String description;
    private final CommandCaller caller;
    private final Map<String, CommandImpl> subCommands;

    public CommandImpl(String name, String description, CommandCaller caller) {
        this.name = name;
        this.description = description;
        this.caller = caller;
        this.subCommands = new TreeMap<String, CommandImpl>();
    }

    public String getName() {
        return this.name;
    }

    public CommandCaller getCaller() {
        return this.caller;
    }

    public String getDescription() {
        return this.description;
    }

    public void registerSubCommand(CommandImpl subCommand) {
        this.subCommands.put(subCommand.getName(), subCommand);
    }

    public Map<String, CommandImpl> getChildCommands() {
        return this.subCommands;
    }

    @Override
    public int compareTo(CommandImpl o) {
        return this.getName().compareTo(o.getName());
    }
}

