/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.StringData")
@ZenRegister
@Document(value="vanilla/api/data/StringData")
public class StringData
implements IData {
    private final StringNBT internal;

    public StringData(StringNBT internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public StringData(String internal) {
        this.internal = StringNBT.func_229705_a_((String)internal);
    }

    @Override
    public IData copy() {
        return new StringData(this.getInternal());
    }

    @Override
    public IData copyInternal() {
        return new StringData(this.getInternal().func_74737_b());
    }

    public StringNBT getInternal() {
        return this.internal;
    }

    @Override
    public boolean contains(IData data) {
        return this.asString().equals(data.asString());
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    public StringData addTogether(StringData data) {
        return new StringData(this.internal.func_150285_a_() + data.getInternal().func_150285_a_());
    }

    @Override
    public String asString() {
        return StringUtils.quoteAndEscape(this.getInternal().func_150285_a_()) + " as string";
    }

    @Override
    public ITextComponent asFormattedComponent(String indentation, int indentDepth) {
        String str = this.toJsonString();
        String quote = str.substring(0, 1);
        IFormattableTextComponent component = new StringTextComponent(str.substring(1, str.length() - 1)).func_240699_a_(IData.SYNTAX_HIGHLIGHTING_STRING);
        return new StringTextComponent(quote).func_240699_a_(IData.SYNTAX_HIGHLIGHTING_QUOTE).func_230529_a_((ITextComponent)component).func_230529_a_((ITextComponent)new StringTextComponent(quote).func_240699_a_(IData.SYNTAX_HIGHLIGHTING_QUOTE));
    }

    @Override
    public String toJsonString() {
        return StringUtils.quoteAndEscape(this.getInternal().func_150285_a_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringData that = (StringData)o;
        return this.internal.equals((Object)that.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }
}

