/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.game;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.util.text.MCTextFormatting;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.Direction;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.game.MCGame")
@Document(value="vanilla/api/game/MCGame")
public class MCGame {
    @ZenCodeType.Getter(value="directionAxises")
    public Collection<Direction.Axis> getMCDirectionAxis() {
        return Arrays.stream(Direction.Axis.values()).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="effects")
    public Collection<Effect> getMCEffects() {
        return ForgeRegistries.POTIONS.getValues();
    }

    @ZenCodeType.Getter(value="enchantments")
    public Collection<Enchantment> getEnchantments() {
        return ForgeRegistries.ENCHANTMENTS.getValues();
    }

    @ZenCodeType.Getter(value="entityTypes")
    public Collection<MCEntityType> getMCEntityTypes() {
        return ForgeRegistries.ENTITIES.getValues().stream().map(MCEntityType::new).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="fluids")
    public Collection<Fluid> getMCFluids() {
        return ForgeRegistries.FLUIDS.getValues();
    }

    @ZenCodeType.Getter(value="entityClassifications")
    public Collection<EntityClassification> getMCEntityClassification() {
        return Arrays.asList(EntityClassification.values());
    }

    @ZenCodeType.Getter(value="formattings")
    public Collection<MCTextFormatting> getMCTextFormatting() {
        return Arrays.stream(TextFormatting.values()).map(MCTextFormatting::new).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="items")
    public Collection<IItemStack> getMCItemStacks() {
        return ForgeRegistries.ITEMS.getValues().stream().map(Item::func_190903_i).map(MCItemStack::new).filter(stack -> !stack.isEmpty()).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="potions")
    public Collection<Potion> getMCPotions() {
        return ForgeRegistries.POTION_TYPES.getValues();
    }

    @ZenCodeType.Getter(value="recipeTypes")
    public Collection<IRecipeManager> getRecipeTypes() {
        return Registry.field_218367_H.func_239659_c_().stream().map(Map.Entry::getValue).map(RecipeTypeBracketHandler::getOrDefault).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="blocks")
    public Collection<Block> getBlocks() {
        return ForgeRegistries.BLOCKS.getValues();
    }

    @ZenCodeType.Getter(value="blockStates")
    public Collection<BlockState> getBlockStates() {
        return ForgeRegistries.BLOCKS.getValues().stream().flatMap(block -> block.func_176194_O().func_177619_a().stream()).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="villagerProfessions")
    public Collection<VillagerProfession> getProfessions() {
        return ForgeRegistries.PROFESSIONS.getValues();
    }

    @ZenCodeType.Method
    public String localize(String translationKey) {
        return LanguageMap.func_74808_a().func_230503_a_(translationKey);
    }
}

