/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import com.blamejared.crafttweaker.impl.predicate.EnchantmentPredicate;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.IntRangePredicate;
import com.blamejared.crafttweaker.impl.predicate.NBTPredicate;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.ItemPredicate")
@Document(value="vanilla/api/predicate/ItemPredicate")
public final class ItemPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.ItemPredicate> {
    private final List<EnchantmentPredicate> enchantments;
    private final List<EnchantmentPredicate> storedEnchantments;
    private IntRangePredicate amount = IntRangePredicate.unbounded();
    private IntRangePredicate damage = IntRangePredicate.unbounded();
    private NBTPredicate data = new NBTPredicate();
    private Item item;
    private MCTag<Item> tag;
    private Potion potion;

    public ItemPredicate() {
        super(net.minecraft.advancements.criterion.ItemPredicate.field_192495_a);
        this.enchantments = new ArrayList<EnchantmentPredicate>();
        this.storedEnchantments = new ArrayList<EnchantmentPredicate>();
    }

    @ZenCodeType.Method
    public ItemPredicate withMinimumAmount(int min) {
        this.amount = IntRangePredicate.mergeLowerBound(this.amount, min);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withMaximumAmount(int max) {
        this.amount = IntRangePredicate.mergeUpperBound(this.amount, max);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withRangedAmount(int min, int max) {
        this.amount = IntRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withExactAmount(int value) {
        return this.withRangedAmount(value, value);
    }

    @ZenCodeType.Method
    public ItemPredicate withMinimumDamage(int min) {
        this.damage = IntRangePredicate.mergeLowerBound(this.damage, min);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withMaximumDamage(int max) {
        this.damage = IntRangePredicate.mergeUpperBound(this.damage, max);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withRangedDamage(int min, int max) {
        this.damage = IntRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withExactDamage(int value) {
        return this.withRangedDamage(value, value);
    }

    @ZenCodeType.Method
    public ItemPredicate withDataPredicate(Consumer<NBTPredicate> builder) {
        NBTPredicate predicate = new NBTPredicate();
        builder.accept(predicate);
        this.data = predicate;
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withItem(Item definition) {
        this.item = definition;
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withItem(IItemStack itemStack) {
        return this.withItem(itemStack.getDefinition());
    }

    @ZenCodeType.Method
    public ItemPredicate withTag(MCTag<Item> tag) {
        this.tag = tag;
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withPotion(Potion potion) {
        this.potion = potion;
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withEnchantmentPredicate(Consumer<EnchantmentPredicate> builder) {
        EnchantmentPredicate predicate = new EnchantmentPredicate();
        builder.accept(predicate);
        this.enchantments.add(predicate);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withEnchantmentPredicate(Enchantment enchantment, Consumer<EnchantmentPredicate> builder) {
        return this.withEnchantmentPredicate(predicate -> {
            predicate.withEnchantment(enchantment);
            builder.accept((EnchantmentPredicate)predicate);
        });
    }

    @ZenCodeType.Method
    public ItemPredicate withStoredEnchantmentPredicate(Consumer<EnchantmentPredicate> builder) {
        EnchantmentPredicate predicate = new EnchantmentPredicate();
        builder.accept(predicate);
        this.storedEnchantments.add(predicate);
        return this;
    }

    @ZenCodeType.Method
    public ItemPredicate withStoredEnchantmentPredicate(Enchantment enchantment, Consumer<EnchantmentPredicate> builder) {
        return this.withStoredEnchantmentPredicate(predicate -> {
            predicate.withEnchantment(enchantment);
            builder.accept((EnchantmentPredicate)predicate);
        });
    }

    @ZenCodeType.Method
    public ItemPredicate matching(IItemStack stack) {
        return this.matching(stack, false);
    }

    @ZenCodeType.Method
    public ItemPredicate matching(IItemStack stack, boolean matchDamage) {
        return this.matching(stack, matchDamage, false);
    }

    @ZenCodeType.Method
    public ItemPredicate matching(IItemStack stack, boolean matchDamage, boolean matchCount) {
        return this.matching(stack, matchDamage, matchCount, false);
    }

    @ZenCodeType.Method
    public ItemPredicate matching(IItemStack stack, boolean matchDamage, boolean matchCount, boolean matchNbt) {
        IData tag;
        this.withItem(stack);
        if (matchDamage) {
            this.withExactDamage(stack.getDamage());
        }
        if (matchCount) {
            this.withExactAmount(stack.getAmount());
        }
        if (matchNbt && (tag = stack.getTag()) != null) {
            this.withDataPredicate(predicate -> predicate.withData(tag));
        }
        return this;
    }

    @Override
    public boolean isAny() {
        return this.enchantments.isEmpty() && this.storedEnchantments.isEmpty() && this.amount.isAny() && this.damage.isAny() && this.data.isAny() && this.item == null && this.tag == null && this.potion == null;
    }

    @Override
    public net.minecraft.advancements.criterion.ItemPredicate toVanilla() {
        if (this.tag != null && this.item != null) {
            CraftTweakerAPI.logWarning("'ItemPredicate' specifies both an item and a tag: the second will take precedence", new Object[0]);
        }
        return new net.minecraft.advancements.criterion.ItemPredicate(this.tag != null ? CraftTweakerHelper.getITag(this.tag) : null, this.item, (MinMaxBounds.IntBound)this.amount.toVanillaPredicate(), (MinMaxBounds.IntBound)this.damage.toVanillaPredicate(), this.toVanilla(this.enchantments), this.toVanilla(this.storedEnchantments), this.potion, (net.minecraft.advancements.criterion.NBTPredicate)this.data.toVanillaPredicate());
    }

    private net.minecraft.advancements.criterion.EnchantmentPredicate[] toVanilla(List<EnchantmentPredicate> list) {
        return (net.minecraft.advancements.criterion.EnchantmentPredicate[])list.stream().map(IVanillaWrappingPredicate.AnyDefaulting::toVanillaPredicate).toArray(net.minecraft.advancements.criterion.EnchantmentPredicate[]::new);
    }
}

