/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.AdvancementPredicate;
import com.blamejared.crafttweaker.impl.predicate.GameMode;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.IntRangePredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.PlayerPredicate;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameType;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.PlayerPredicate")
@Document(value="vanilla/api/predicate/PlayerPredicate")
public final class PlayerPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.PlayerPredicate> {
    private final Map<Pair<ResourceLocation, ResourceLocation>, IntRangePredicate> statistics = new LinkedHashMap<Pair<ResourceLocation, ResourceLocation>, IntRangePredicate>();
    private final Map<String, Boolean> recipes = new LinkedHashMap<String, Boolean>();
    private final Map<String, AdvancementPredicate> advancements = new LinkedHashMap<String, AdvancementPredicate>();
    private IntRangePredicate experienceLevels = IntRangePredicate.unbounded();
    private GameMode gameMode;

    public PlayerPredicate() {
        super(net.minecraft.advancements.criterion.PlayerPredicate.field_226989_a_);
    }

    @ZenCodeType.Method
    public PlayerPredicate withMinimumExperienceLevel(int min) {
        this.experienceLevels = IntRangePredicate.mergeLowerBound(this.experienceLevels, min);
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withMaximumExperienceLevel(int max) {
        this.experienceLevels = IntRangePredicate.mergeUpperBound(this.experienceLevels, max);
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withBoundedExperienceLevel(int min, int max) {
        this.experienceLevels = IntRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withExactExperienceLevel(int level) {
        return this.withBoundedExperienceLevel(level, level);
    }

    @ZenCodeType.Method
    public PlayerPredicate withGameMode(GameMode mode) {
        this.gameMode = mode;
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withMinimumStatistic(ResourceLocation type, ResourceLocation name, int min) {
        Pair key = Pair.of((Object)type, (Object)name);
        this.statistics.put((Pair<ResourceLocation, ResourceLocation>)key, IntRangePredicate.mergeLowerBound(this.statistics.get(key), min));
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withMaximumStatistic(ResourceLocation type, ResourceLocation name, int max) {
        Pair key = Pair.of((Object)type, (Object)name);
        this.statistics.put((Pair<ResourceLocation, ResourceLocation>)key, IntRangePredicate.mergeUpperBound(this.statistics.get(key), max));
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withBoundedStatistic(ResourceLocation type, ResourceLocation name, int minValue, int maxValue) {
        this.statistics.put((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)type, (Object)name), IntRangePredicate.bounded(minValue, maxValue));
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withExactStatistic(ResourceLocation type, ResourceLocation name, int value) {
        return this.withBoundedStatistic(type, name, value, value);
    }

    @ZenCodeType.Method
    public PlayerPredicate withUnlockedRecipe(String name) {
        this.recipes.put(name, true);
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withLockedRecipe(String name) {
        this.recipes.put(name, false);
        return this;
    }

    @ZenCodeType.Method
    public PlayerPredicate withAdvancementPredicate(String advancement, Consumer<AdvancementPredicate> builder) {
        AdvancementPredicate predicate = new AdvancementPredicate();
        builder.accept(predicate);
        this.advancements.put(advancement, predicate);
        return this;
    }

    @Override
    public boolean isAny() {
        return this.experienceLevels.isAny() && this.gameMode == null && this.statistics.isEmpty() && this.recipes.isEmpty() && (this.advancements.isEmpty() || this.advancements.values().stream().allMatch(AdvancementPredicate::isAny));
    }

    @Override
    public net.minecraft.advancements.criterion.PlayerPredicate toVanilla() {
        if (this.isAny()) {
            return net.minecraft.advancements.criterion.PlayerPredicate.field_226989_a_;
        }
        try {
            return new net.minecraft.advancements.criterion.PlayerPredicate((MinMaxBounds.IntBound)this.experienceLevels.toVanillaPredicate(), this.gameMode == null ? GameType.NOT_SET : this.gameMode.toGameType(), this.toVanillaStats(this.statistics), this.toVanillaRecipes(this.recipes), this.toVanillaAdvancements(this.advancements));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Map<Stat<?>, MinMaxBounds.IntBound> toVanillaStats(Map<Pair<ResourceLocation, ResourceLocation>, IntRangePredicate> map) {
        return map.entrySet().stream().map(this::toVanillaStat).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map.Entry<Stat<?>, MinMaxBounds.IntBound> toVanillaStat(Map.Entry<Pair<ResourceLocation, ResourceLocation>, IntRangePredicate> entry) {
        StatType type = (StatType)ForgeRegistries.STAT_TYPES.getValue((ResourceLocation)entry.getKey().getFirst());
        if (type == null) {
            return null;
        }
        Stat stat = this.toStat(type, (ResourceLocation)entry.getKey().getSecond());
        if (stat == null) {
            return null;
        }
        return new AbstractMap.SimpleImmutableEntry(stat, (MinMaxBounds.IntBound)entry.getValue().toVanillaPredicate());
    }

    private <T> Stat<T> toStat(StatType<T> type, ResourceLocation name) {
        Object thing = type.func_199080_a().func_82594_a(name);
        if (thing == null) {
            return null;
        }
        return type.func_199076_b(thing);
    }

    private Object2BooleanMap<ResourceLocation> toVanillaRecipes(Map<String, Boolean> map) {
        Object2BooleanOpenHashMap vanilla = new Object2BooleanOpenHashMap();
        map.forEach((arg_0, arg_1) -> PlayerPredicate.lambda$toVanillaRecipes$0((Object2BooleanMap)vanilla, arg_0, arg_1));
        return vanilla;
    }

    private Map<ResourceLocation, PlayerPredicate.IAdvancementPredicate> toVanillaAdvancements(Map<String, AdvancementPredicate> predicateMap) {
        return predicateMap.entrySet().stream().filter(it -> !((AdvancementPredicate)it.getValue()).isAny()).map(it -> new AbstractMap.SimpleImmutableEntry<ResourceLocation, PlayerPredicate.IAdvancementPredicate>(new ResourceLocation((String)it.getKey()), ((AdvancementPredicate)it.getValue()).toVanillaPredicate())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static /* synthetic */ void lambda$toVanillaRecipes$0(Object2BooleanMap vanilla, String k, Boolean v) {
        vanilla.put((Object)new ResourceLocation(k), v.booleanValue());
    }
}

