/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class ExcludingModsAndDelegatingTargetingRule
implements ITargetingRule {
    private final ITargetingRule delegate;
    private final Collection<String> exclusions;

    private ExcludingModsAndDelegatingTargetingRule(ITargetingRule delegate, Collection<String> exclusions) {
        this.delegate = delegate;
        this.exclusions = exclusions;
    }

    public static ExcludingModsAndDelegatingTargetingRule of(ITargetingRule delegate, Collection<String> exclusions) {
        Objects.requireNonNull(delegate);
        if (exclusions.isEmpty()) {
            throw new IllegalArgumentException("Unable to create an exclusion for mods without any mods to exclude");
        }
        if (delegate instanceof ExcludingModsAndDelegatingTargetingRule) {
            ExcludingModsAndDelegatingTargetingRule delegatingRule = (ExcludingModsAndDelegatingTargetingRule)delegate;
            return ExcludingModsAndDelegatingTargetingRule.of(delegatingRule.delegate, (Collection)Util.func_200696_a(new HashSet<String>(exclusions), it -> it.addAll(delegatingRule.exclusions)));
        }
        return new ExcludingModsAndDelegatingTargetingRule(delegate, exclusions);
    }

    public static ExcludingModsAndDelegatingTargetingRule of(ITargetingRule delegate, String ... exclusions) {
        return ExcludingModsAndDelegatingTargetingRule.of(delegate, new HashSet<String>(Arrays.asList(exclusions)));
    }

    public static ExcludingModsAndDelegatingTargetingRule of(ITargetingRule delegate, WrapperRecipe ... exclusions) {
        return ExcludingModsAndDelegatingTargetingRule.of(delegate, Arrays.stream(exclusions).map(WrapperRecipe::getRecipe).map(IRecipe::func_199560_c).map(ResourceLocation::func_110624_b).collect(Collectors.toSet()));
    }

    @Override
    public boolean shouldBeReplaced(IRecipe<?> recipe, IRecipeManager manager) {
        return !this.exclusions.contains(recipe.func_199560_c().func_110624_b()) && this.delegate.shouldBeReplaced(recipe, manager);
    }

    @Override
    public String describe() {
        return String.format("%s, but excluding mods {%s}", this.delegate.describe(), String.join((CharSequence)", ", this.exclusions));
    }
}

