/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagAdd;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagCreate;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagRemove;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tags/TagManagerItem")
@ZenCodeType.Name(value="crafttweaker.api.tag.TagManagerItem")
public class TagManagerItem
implements TagManager<Item> {
    public static final TagManagerItem INSTANCE = new TagManagerItem();

    private TagManagerItem() {
    }

    @Override
    @Nonnull
    public Class<Item> getElementClass() {
        return Item.class;
    }

    @Override
    public String getTagFolder() {
        return "items";
    }

    @Override
    public List<MCTag<Item>> getAllTagsFor(Item element) {
        return this.getTagCollection().func_199913_a((Object)element).stream().map(location -> new MCTag<Item>((ResourceLocation)location, this)).collect(Collectors.toList());
    }

    @Override
    public void addElements(MCTag<Item> to, List<Item> toAdd) {
        ITag<Item> internal = this.getInternal(to);
        if (internal == null) {
            Tag tagFromContents = new Tag((Set)Sets.newHashSet(toAdd), Item.class);
            CraftTweakerAPI.apply(new ActionTagCreate<Item>(this.getTagCollection(), (ITag<Item>)tagFromContents, to));
        } else {
            CraftTweakerAPI.apply(new ActionTagAdd<Item>(internal, toAdd, to));
        }
    }

    @Override
    public void removeElements(MCTag<Item> from, List<Item> toRemove) {
        ITag<Item> internal = this.getInternal(from);
        CraftTweakerAPI.apply(new ActionTagRemove<Item>(internal, toRemove, from));
    }

    @Override
    public List<Item> getElementsInTag(MCTag<Item> theTag) {
        ITag<Item> internal = this.getInternal(theTag);
        if (internal == null) {
            return Collections.emptyList();
        }
        return internal.func_230236_b_();
    }

    @Override
    public ITag<Item> getInternal(MCTag<Item> theTag) {
        return this.getTagCollection().func_199910_a(theTag.getIdInternal());
    }

    @Override
    public ITagCollection<Item> getTagCollection() {
        return TagCollectionManager.func_242178_a().func_241836_b();
    }
}

