/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.expression.ArrayExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionArray
extends ParsedExpression {
    public static final List<BiFunction<ParsedExpressionArray, ExpressionScope, IPartialExpression>> compileOverrides = new ArrayList<BiFunction<ParsedExpressionArray, ExpressionScope, IPartialExpression>>(0);
    public final List<ParsedExpression> contents;

    public ParsedExpressionArray(CodePosition position, List<ParsedExpression> contents) {
        super(position);
        this.contents = contents;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        ExpressionScope contentScope;
        for (BiFunction<ParsedExpressionArray, ExpressionScope, IPartialExpression> compileOverride : compileOverrides) {
            IPartialExpression apply = compileOverride.apply(this, scope);
            if (apply == null) continue;
            return apply;
        }
        TypeID asBaseType = null;
        TypeID asType = null;
        boolean couldHintType = false;
        for (TypeID hint : scope.hints) {
            ArrayTypeID arrayHint = null;
            if (hint instanceof ArrayTypeID) {
                arrayHint = (ArrayTypeID)hint;
                asType = hint;
            }
            if (hint.isOptional() && hint.withoutOptional() instanceof ArrayTypeID) {
                arrayHint = (ArrayTypeID)hint.withoutOptional();
                asType = hint.withoutOptional();
            }
            if (arrayHint == null || arrayHint.dimension != 1) continue;
            asBaseType = arrayHint.elementType;
            couldHintType = true;
        }
        Expression[] cContents = new Expression[this.contents.size()];
        if (couldHintType) {
            contentScope = scope.withHint(asBaseType);
            for (int i = 0; i < this.contents.size(); ++i) {
                cContents[i] = this.contents.get(i).compile(contentScope).eval().castImplicit(this.position, scope, asBaseType);
            }
        } else {
            int i;
            if (this.contents.isEmpty()) {
                throw new CompileException(this.position, CompileExceptionCode.UNTYPED_EMPTY_ARRAY, "Empty array with unknown type");
            }
            contentScope = scope.withoutHints();
            TypeID resultType = null;
            for (i = 0; i < this.contents.size(); ++i) {
                TypeID joinedType;
                cContents[i] = this.contents.get(i).compileKey(contentScope).eval();
                TypeID typeID = joinedType = resultType == null ? cContents[i].type : scope.getTypeMembers(resultType).union(cContents[i].type);
                if (joinedType == null) {
                    throw new CompileException(this.position, CompileExceptionCode.TYPE_CANNOT_UNITE, "Could not combine " + resultType + " with " + cContents[i].type);
                }
                resultType = joinedType;
            }
            for (i = 0; i < this.contents.size(); ++i) {
                cContents[i] = cContents[i].castImplicit(this.position, scope, resultType);
            }
            asType = scope.getTypeRegistry().getArray(resultType, 1);
        }
        return new ArrayExpression(this.position, cContents, asType);
    }

    @Override
    public Expression compileKey(ExpressionScope scope) throws CompileException {
        if (this.contents.size() == 1) {
            return this.contents.get(0).compile(scope).eval();
        }
        return this.compile(scope).eval();
    }

    @Override
    public boolean hasStrongType() {
        return false;
    }
}

