/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LubricatedHandler {
    static final Map<Class<? extends TileEntity>, ILubricationHandler<? extends TileEntity>> lubricationHandlers = new HashMap<Class<? extends TileEntity>, ILubricationHandler<? extends TileEntity>>();
    public static List<LubricatedTileInfo> lubricatedTiles = new ArrayList<LubricatedTileInfo>();

    public static <E extends TileEntity> void registerLubricatedTile(Class<E> tileClass, Supplier<ILubricationHandler<E>> handler) {
        ILubricationHandler<E> instance = handler.get();
        lubricationHandlers.put(tileClass, instance);
    }

    public static ILubricationHandler<TileEntity> getHandlerForTile(TileEntity te) {
        Class<?> teClass;
        if (te != null && lubricationHandlers.containsKey(teClass = te.getClass())) {
            ILubricationHandler<TileEntity> tmp = lubricationHandlers.get(teClass);
            return tmp;
        }
        return null;
    }

    public static boolean lubricateTile(TileEntity tile, int ticks) {
        return LubricatedHandler.lubricateTile(tile, ticks, false, -1);
    }

    public static boolean lubricateTile(TileEntity tile, int ticks, boolean additive, int cap) {
        if (tile instanceof MultiblockPartTileEntity) {
            tile = ((MultiblockPartTileEntity)tile).master();
        }
        if (LubricatedHandler.getHandlerForTile(tile) != null) {
            BlockPos pos = tile.func_174877_v();
            for (int i = 0; i < lubricatedTiles.size(); ++i) {
                LubricatedTileInfo info = lubricatedTiles.get(i);
                if (!info.pos.equals((Object)pos) || info.world != tile.func_145831_w().func_234923_W_()) continue;
                if (info.ticks >= ticks) {
                    if (additive) {
                        info.ticks = cap == -1 ? (info.ticks += ticks) : Math.min(cap, info.ticks + ticks);
                        return true;
                    }
                    return false;
                }
                info.ticks = ticks;
                return true;
            }
            LubricatedTileInfo lti = new LubricatedTileInfo((RegistryKey<World>)tile.func_145831_w().func_234923_W_(), tile.func_174877_v(), ticks);
            lubricatedTiles.add(lti);
            return true;
        }
        return false;
    }

    public static class LubricantEffect
    extends ChemthrowerHandler.ChemthrowerEffect {
        public void applyToEntity(LivingEntity target, PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            if (target instanceof IronGolemEntity && LubricantHandler.isValidLube(fluid)) {
                int amount = Math.max(1, (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() / LubricantHandler.getLubeAmount(fluid)) * 4 / 3;
                EffectInstance activeSpeed = target.func_70660_b(Effects.field_76424_c);
                int ticksSpeed = amount;
                if (activeSpeed != null && activeSpeed.func_76458_c() <= 1) {
                    ticksSpeed = Math.min(activeSpeed.func_76459_b() + amount, 1200);
                }
                EffectInstance activeStrength = target.func_70660_b(Effects.field_76420_g);
                int ticksStrength = amount;
                if (activeStrength != null && activeStrength.func_76458_c() <= 1) {
                    ticksStrength = Math.min(activeStrength.func_76459_b() + amount, 1200);
                }
                target.func_195064_c(new EffectInstance(Effects.field_76424_c, ticksSpeed, 1));
                target.func_195064_c(new EffectInstance(Effects.field_76420_g, ticksStrength, 1));
            }
        }

        public void applyToBlock(World world, RayTraceResult mop, PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            if (LubricantHandler.isValidLube(fluid)) {
                int amount = Math.max(1, (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() / LubricantHandler.getLubeAmount(fluid)) * 2 / 3;
                LubricatedHandler.lubricateTile(world.func_175625_s(new BlockPos(mop.func_216347_e())), amount, true, 1200);
            }
        }
    }

    public static class LubricatedTileInfo {
        public BlockPos pos;
        public RegistryKey<World> world;
        public int ticks;

        public LubricatedTileInfo(RegistryKey<World> registryKey, BlockPos pos, int ticks) {
            this.world = registryKey;
            this.pos = pos;
            this.ticks = ticks;
        }

        public LubricatedTileInfo(CompoundNBT tag) {
            int ticks = tag.func_74762_e("ticks");
            int x = tag.func_74762_e("x");
            int y = tag.func_74762_e("y");
            int z = tag.func_74762_e("z");
            String name = tag.func_74779_i("world");
            this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(name));
            this.pos = new BlockPos(x, y, z);
            this.ticks = ticks;
        }

        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("ticks", this.ticks);
            tag.func_74768_a("x", this.pos.func_177958_n());
            tag.func_74768_a("y", this.pos.func_177956_o());
            tag.func_74768_a("z", this.pos.func_177952_p());
            tag.func_74778_a("world", this.world.getRegistryName().toString());
            return tag;
        }
    }

    public static interface ILubricationHandler<E extends TileEntity> {
        public Tuple<BlockPos, Direction> getGhostBlockPosition(World var1, E var2);

        public Vector3i getStructureDimensions();

        public boolean isMachineEnabled(World var1, E var2);

        public TileEntity isPlacedCorrectly(World var1, AutoLubricatorTileEntity var2, Direction var3);

        public void lubricate(World var1, int var2, E var3);

        @OnlyIn(value=Dist.CLIENT)
        public void renderPipes(AutoLubricatorTileEntity var1, E var2, MatrixStack var3, IRenderTypeBuffer var4, int var5, int var6);

        public void spawnLubricantParticles(World var1, AutoLubricatorTileEntity var2, Direction var3, E var4);
    }
}

