/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.particle.IPParticleTypes;
import flaxbeard.immersivepetroleum.common.util.sounds.IPSounds;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FlarestackTileEntity
extends IPTileEntityBase
implements ITickableTileEntity,
IEBlockInterfaces.ISoundTile {
    static final DamageSource FLARESTACK = new DamageSource("ipFlarestack").func_76348_h().func_76361_j();
    protected boolean isRedstoneInverted;
    protected boolean isActive;
    protected short drained;
    protected FluidTank tank = new FluidTank(250, fstack -> fstack != FluidStack.EMPTY && FlarestackHandler.isBurnable(fstack));
    private LazyOptional<IFluidHandler> inputHandler;

    public FlarestackTileEntity() {
        super((TileEntityType)IPTileTypes.FLARE.get());
    }

    public void invertRedstone() {
        this.isRedstoneInverted = !this.isRedstoneInverted;
        this.func_70296_d();
    }

    public boolean isRedstoneInverted() {
        return this.isRedstoneInverted;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public short getFlow() {
        return this.drained;
    }

    @Override
    public void readCustom(BlockState state, CompoundNBT nbt) {
        this.isRedstoneInverted = nbt.func_74767_n("inverted");
        this.isActive = nbt.func_74767_n("active");
        this.drained = nbt.func_74765_d("drained");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustom(CompoundNBT nbt) {
        nbt.func_74757_a("inverted", this.isRedstoneInverted);
        nbt.func_74757_a("active", this.isActive);
        nbt.func_74777_a("drained", this.drained);
        CompoundNBT tank = this.tank.writeToNBT(new CompoundNBT());
        nbt.func_218657_a("tank", (INBT)tank);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (side == null || side == Direction.DOWN)) {
            if (this.inputHandler == null) {
                this.inputHandler = LazyOptional.of(() -> {
                    TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v());
                    if (te != null && te instanceof FlarestackTileEntity) {
                        return ((FlarestackTileEntity)te).tank;
                    }
                    return null;
                });
            }
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.inputHandler != null) {
            this.inputHandler.invalidate();
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.inputHandler != null) {
            this.inputHandler.invalidate();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound(IPSounds.FLARESTACK, (TileEntity)this, this.isActive, 1.0f, 0.75f);
            if (this.isActive) {
                if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                    float xPos = (float)this.field_174879_c.func_177958_n() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                    float zPos = (float)this.field_174879_c.func_177952_p() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                    float yPos = (float)this.field_174879_c.func_177956_o() + 1.875f + 0.2f * this.field_145850_b.field_73012_v.nextFloat();
                    this.field_145850_b.func_195594_a((IParticleData)IPParticleTypes.FLARE_FIRE, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)(0.0625f + (float)this.drained / (float)this.tank.getCapacity() * 0.125f), 0.0);
                }
            } else if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                float xPos = (float)this.field_174879_c.func_177958_n() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                float zPos = (float)this.field_174879_c.func_177952_p() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                float yPos = (float)this.field_174879_c.func_177956_o() + 1.6f;
                float xa = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.00625f;
                float ya = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.00625f;
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)xPos, (double)yPos, (double)zPos, (double)xa, (double)0.025f, (double)ya);
            }
        } else {
            boolean lastActive = this.isActive;
            this.isActive = false;
            int redstone = this.field_145850_b.func_175687_A(this.field_174879_c);
            if (this.isRedstoneInverted()) {
                redstone = 15 - redstone;
            }
            if (redstone > 0 && this.tank.getFluidAmount() > 0) {
                float signal = (float)redstone / 15.0f;
                FluidStack fs = this.tank.drain((int)((float)this.tank.getCapacity() * signal), IFluidHandler.FluidAction.SIMULATE);
                if (fs.getAmount() > 0) {
                    this.tank.drain(fs.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    this.drained = (short)fs.getAmount();
                    this.isActive = true;
                }
            }
            if (this.isActive && this.field_145850_b.func_82737_E() % 10L == 0L) {
                BlockPos min = this.field_174879_c.func_177982_a(-1, 2, -1);
                BlockPos max = min.func_177982_a(3, 3, 3);
                List list = this.func_145831_w().func_217357_a(Entity.class, new AxisAlignedBB(min, max));
                if (!list.isEmpty()) {
                    list.forEach(e -> {
                        if (!e.func_230279_az_()) {
                            e.func_70015_d(15);
                            e.func_70097_a(FLARESTACK, 6.0f * ((float)this.drained / (float)this.tank.getCapacity()));
                        }
                    });
                }
            }
            if (lastActive != this.isActive || !this.field_145850_b.field_72995_K && this.isActive) {
                this.func_70296_d();
            }
        }
    }

    public boolean shouldPlaySound(String sound) {
        return true;
    }
}

