/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.api.crafting.builders.DistillationRecipeBuilder;
import flaxbeard.immersivepetroleum.common.IPContent;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class DistillationRecipeSerializer
extends IERecipeSerializer<DistillationRecipe> {
    public DistillationRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
        JsonArray fluidResults = JSONUtils.func_151214_t((JsonObject)json, (String)"results");
        JsonArray itemResults = JSONUtils.func_151214_t((JsonObject)json, (String)"byproducts");
        FluidStack[] fluidOutput = new FluidStack[fluidResults.size()];
        for (int i = 0; i < fluidOutput.length; ++i) {
            fluidOutput[i] = ApiUtils.jsonDeserializeFluidStack((JsonObject)fluidResults.get(i).getAsJsonObject());
        }
        ArrayList<Object> byproducts = new ArrayList<Object>(0);
        ArrayList<Object> chances = new ArrayList<Object>(0);
        for (int i = 0; i < itemResults.size(); ++i) {
            Tuple<ItemStack, Double> chancedStack = DistillationRecipeBuilder.deserializeItemStackWithChance(itemResults.get(i).getAsJsonObject());
            byproducts.add(chancedStack.func_76341_a());
            chances.add(chancedStack.func_76340_b());
        }
        if (byproducts.size() != chances.size()) {
            int d = Math.abs(chances.size() - byproducts.size());
            throw new JsonSyntaxException(d + " byproduct" + (d > 1 ? "s have" : " has") + " a missing value or too many.");
        }
        ItemStack[] array0 = byproducts.toArray(new ItemStack[0]);
        double[] array1 = new double[chances.size()];
        for (int i = 0; i < chances.size(); ++i) {
            array1[i] = (Double)chances.get(i);
        }
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
        return new DistillationRecipe(recipeId, fluidOutput, array0, input, energy, time, array1);
    }

    public DistillationRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        FluidStack[] fluidOutput = new FluidStack[buffer.readInt()];
        for (int i = 0; i < fluidOutput.length; ++i) {
            fluidOutput[i] = buffer.readFluidStack();
        }
        ItemStack[] byproducts = new ItemStack[buffer.readInt()];
        for (int i = 0; i < byproducts.length; ++i) {
            byproducts[i] = buffer.func_150791_c();
        }
        double[] chances = new double[buffer.readInt()];
        for (int i = 0; i < chances.length; ++i) {
            chances[i] = buffer.readDouble();
        }
        FluidTagInput input = FluidTagInput.read((PacketBuffer)buffer);
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new DistillationRecipe(recipeId, fluidOutput, byproducts, input, energy, time, chances);
    }

    public void write(PacketBuffer buffer, DistillationRecipe recipe) {
        buffer.writeInt(recipe.getFluidOutputs().size());
        for (FluidStack stack : recipe.getFluidOutputs()) {
            buffer.writeFluidStack(stack);
        }
        buffer.writeInt(recipe.getItemOutputs().size());
        for (FluidStack stack : recipe.getItemOutputs()) {
            buffer.func_150788_a((ItemStack)stack);
        }
        buffer.writeInt(recipe.chances().length);
        for (Object d : (Object)recipe.chances()) {
            buffer.writeDouble((double)d);
        }
        recipe.getInputFluid().write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
    }

    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IPContent.Multiblock.distillationtower);
    }
}

