/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.particle;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

public class FlareFire
extends SimpleAnimatedParticle {
    final double ogMotionY;
    final float red;
    final float green;
    final float blue;
    final float rotation;

    protected FlareFire(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, IAnimatedSprite spriteWithAge) {
        super(world, x, y, z, spriteWithAge, 0.0f);
        this.func_187115_a(0.5f, 0.5f);
        this.func_217566_b(spriteWithAge);
        this.func_191238_f(1.0f);
        this.func_70538_b(1.0f, 1.0f, 1.0f);
        this.func_187114_a(60);
        this.field_70544_f = 0.5f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
        this.ogMotionY = motionY;
        this.rotation = 0.25f * (world.field_73012_v.nextFloat() - 0.5f);
        this.field_190015_G = 360.0f * world.field_73012_v.nextFloat();
        this.field_190014_F = this.field_190015_G + this.rotation * world.field_73012_v.nextFloat();
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
    }

    public void func_189213_a() {
        float f = (float)this.field_70546_d / (float)this.field_70547_e;
        Vector3f vec = Wind.getDirection();
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        if (this.field_70546_d == this.field_70547_e - 36) {
            this.field_70553_i = this.field_70551_j = (float)((double)0.4f * Math.random());
            this.field_70552_h = this.field_70551_j;
        }
        this.func_217566_b(this.field_217584_C);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_190015_G = this.field_190014_F;
        this.func_187110_a(vec.func_195899_a() * f, this.ogMotionY * (double)(1.0f - f), vec.func_195902_c() * f);
        this.field_190014_F += this.rotation;
    }

    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class Wind {
        private static Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
        private static long lastGT;
        private static float lastDirection;
        private static float thisDirection;

        public static Vector3f getDirection() {
            return vec;
        }

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.START) {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return;
                }
                long gameTime = world.func_82737_E();
                if (gameTime / 20L != lastGT) {
                    lastGT = gameTime / 20L;
                    double fGameTime = (double)gameTime / 20.0;
                    Random lastRand = new Random(MathHelper.func_76128_c((double)fGameTime));
                    Random thisRand = new Random(MathHelper.func_76143_f((double)fGameTime));
                    lastDirection = lastRand.nextFloat() * 360.0f;
                    thisDirection = thisRand.nextFloat() * 360.0f;
                }
                double interpDirection = MathHelper.func_219799_g((float)((float)(gameTime % 20L) / 20.0f), (float)lastDirection, (float)thisDirection);
                float xSpeed = (float)Math.sin(interpDirection) * 0.1f;
                float zSpeed = (float)Math.cos(interpDirection) * 0.1f;
                vec = new Vector3f(xSpeed, 0.0f, zSpeed);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlareFire(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

