/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.PumpjackHandler;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.ReservoirWorldInfo;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.util.commands.CommandUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ReservoirCommand {
    private ReservoirCommand() {
    }

    public static LiteralArgumentBuilder<CommandSource> create() {
        LiteralArgumentBuilder lab = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reservoir").executes(source -> {
            CommandUtils.sendHelp((CommandSource)source.getSource(), "");
            return 1;
        })).requires(source -> source.func_197034_c(4));
        lab.then(Commands.func_197057_a((String)"get").executes(source -> ReservoirCommand.get(((CommandSource)source.getSource()).func_197035_h())));
        lab.then(ReservoirCommand.setReservoir());
        lab.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"setAmount").executes(source -> {
            CommandUtils.sendHelp((CommandSource)source.getSource(), ".setAmount");
            return 1;
        })).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> ReservoirCommand.setAmount(((CommandSource)context.getSource()).func_197035_h(), (Integer)context.getArgument("amount", Integer.class)))));
        lab.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"setCapacity").executes(source -> {
            CommandUtils.sendHelp((CommandSource)source.getSource(), ".setCapacity");
            return 1;
        })).then(Commands.func_197056_a((String)"capacity", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> ReservoirCommand.setCapacity(((CommandSource)context.getSource()).func_197035_h(), (Integer)context.getArgument("capacity", Integer.class)))));
        return lab;
    }

    static int get(ServerPlayerEntity playerEntity) {
        ReservoirWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        String h = I18n.func_135052_a((String)"chat.immersivepetroleum.command.reservoir.get", (Object[])new Object[]{TextFormatting.GOLD + (info.type != null ? info.type.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + (info.overrideType != null ? info.overrideType.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + info.current + "/" + info.capacity + " mB" + TextFormatting.RESET});
        for (String g : h.split("<br>")) {
            playerEntity.func_145747_a((ITextComponent)new StringTextComponent(g), Util.field_240973_b_);
        }
        return 1;
    }

    static LiteralArgumentBuilder<CommandSource> setReservoir() {
        RequiredArgumentBuilder nameArg = Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string());
        ((RequiredArgumentBuilder)nameArg.suggests((context, builder) -> ISuggestionProvider.func_197013_a(PumpjackHandler.reservoirs.values().stream().map(type -> type.name), (SuggestionsBuilder)builder)).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            ReservoirCommand.setReservoir((CommandContext<CommandSource>)command, player.func_233580_cy_().func_177958_n() >> 4, player.func_233580_cy_().func_177952_p() >> 4);
            return 1;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(command -> {
            ColumnPos pos = ColumnPosArgument.func_218101_a((CommandContext)command, (String)"location");
            ReservoirCommand.setReservoir((CommandContext<CommandSource>)command, pos.field_219439_a, pos.field_219440_b);
            return 1;
        }));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").executes(source -> {
            CommandUtils.sendHelp((CommandSource)source.getSource(), ".set");
            return 1;
        })).then((ArgumentBuilder)nameArg);
    }

    static void setReservoir(CommandContext<CommandSource> context, int xChunk, int zChunk) {
        CommandSource sender = (CommandSource)context.getSource();
        ReservoirWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo((World)sender.func_197023_e(), xChunk, zChunk);
        String name = (String)context.getArgument("name", String.class);
        PumpjackHandler.ReservoirType reservoir = null;
        for (PumpjackHandler.ReservoirType res : PumpjackHandler.reservoirs.values()) {
            if (!res.name.equalsIgnoreCase(name)) continue;
            reservoir = res;
        }
        if (reservoir == null) {
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.invalidReservoir", new Object[]{name}), true);
            return;
        }
        info.overrideType = reservoir;
        IPSaveData.markInstanceAsDirty();
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.sucess", new Object[]{reservoir.name}), true);
    }

    static int set(ServerPlayerEntity playerEntity, String name) {
        ReservoirWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        PumpjackHandler.ReservoirType reservoir = null;
        for (PumpjackHandler.ReservoirType res : PumpjackHandler.reservoirs.values()) {
            if (!res.name.equalsIgnoreCase(name)) continue;
            reservoir = res;
        }
        if (reservoir == null) {
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.invalidReservoir", new Object[]{name}), Util.field_240973_b_);
            return 1;
        }
        info.overrideType = reservoir;
        playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.sucess", new Object[]{reservoir.name}), Util.field_240973_b_);
        IPSaveData.markInstanceAsDirty();
        return 1;
    }

    static int setAmount(ServerPlayerEntity playerEntity, int amount) {
        ReservoirWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        info.current = amount = Math.min(info.capacity, Math.max(0, amount));
        playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.setAmount.sucess", new Object[]{Integer.toString(amount)}), Util.field_240973_b_);
        IPSaveData.markInstanceAsDirty();
        return 1;
    }

    static int setCapacity(ServerPlayerEntity playerEntity, int amount) {
        ReservoirWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        info.capacity = amount = Math.max(0, amount);
        playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.setCapacity.sucess", new Object[]{Integer.toString(amount)}), Util.field_240973_b_);
        IPSaveData.markInstanceAsDirty();
        return 1;
    }

    static ReservoirWorldInfo getOilWorldInfo(ServerPlayerEntity playerEntity) {
        ChunkPos coords = new ChunkPos(playerEntity.func_233580_cy_());
        return PumpjackHandler.getOrCreateOilWorldInfo(playerEntity.func_130014_f_(), coords.field_77276_a, coords.field_77275_b);
    }
}

