/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.split;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;

public final class SplitPacket {
    private final int id;
    private final int index;
    private final short sessionId;
    private final boolean hasMore;
    private final PacketBuffer payload;

    static SplitPacket readFrom(PacketBuffer buffer) {
        int id = buffer.func_150792_a();
        int index = buffer.func_150792_a();
        short sessionId = buffer.readShort();
        boolean hasMore = buffer.readBoolean();
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer((int)buffer.readableBytes(), (int)Integer.MAX_VALUE));
        buffer.readBytes((ByteBuf)payload);
        return new SplitPacket(id, index, sessionId, hasMore, payload);
    }

    SplitPacket(int id, int index, short sessionId, boolean hasMore, PacketBuffer payload) {
        this.id = id;
        this.index = index;
        this.sessionId = sessionId;
        this.hasMore = hasMore;
        this.payload = payload;
    }

    void writeTo(PacketBuffer buffer) {
        buffer.func_150787_b(this.id);
        buffer.func_150787_b(this.index);
        buffer.writeShort((int)this.sessionId);
        buffer.writeBoolean(this.hasMore);
        buffer.writeBytes((ByteBuf)this.payload);
    }

    public int getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public short getSessionId() {
        return this.sessionId;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public PacketBuffer getPayload() {
        return this.payload;
    }
}

